/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class MergeScanner
implements ResultScanner {
    ResultScanner scanner1;
    ResultScanner scanner2;
    Scan scan;
    Result r1;
    Result r2;
    boolean r1Exhausted = false;
    boolean r2Exhausted = false;

    MergeScanner(Scan scan, ResultScanner scanner1, ResultScanner scanner2) {
        this.scan = scan;
        this.scanner1 = scanner1;
        this.scanner2 = scanner2;
    }

    @Override
    public Result next() throws IOException {
        Result r;
        if (this.r1 == null && !this.r1Exhausted) {
            this.r1 = this.scanner1.next();
        }
        if (this.r2 == null && !this.r2Exhausted) {
            this.r2 = this.scanner2.next();
        }
        if (this.r1 == null) {
            r = this.r2;
            this.r1Exhausted = true;
            this.r2 = null;
        } else if (this.r2 == null) {
            r = this.r1;
            this.r2Exhausted = true;
            this.r1 = null;
        } else {
            int compare = Bytes.compareTo((byte[])this.r1.getRow(), (byte[])this.r2.getRow());
            if (this.scan.isReversed()) {
                compare *= -1;
            }
            if (compare < 0) {
                r = this.r1;
                this.r1 = null;
            } else if (compare == 0) {
                r = MergeScanner.mergeResultsOfSameRow(this.r1, this.r2, this.scan.getMaxVersions());
                this.r1 = null;
                this.r2 = null;
            } else {
                r = this.r2;
                this.r2 = null;
            }
        }
        return r;
    }

    @Override
    public void close() {
        this.scanner1.close();
        this.scanner2.close();
    }

    @Override
    public boolean renewLease() {
        return this.scanner1.renewLease() && this.scanner2.renewLease();
    }

    @Override
    public ScanMetrics getScanMetrics() {
        return this.scanner2.getScanMetrics();
    }

    public static Result mergeResultsOfSameRow(Result r1, Result r2, int maxVersions) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        Cell[] allCells = (Cell[])ArrayUtils.addAll((Object[])r1.rawCells(), (Object[])r2.rawCells());
        Arrays.sort(allCells, CellComparatorImpl.COMPARATOR);
        LinkedList<Cell> l = new LinkedList<Cell>();
        Cell prevCell = null;
        int versions = 0;
        for (Cell cell : allCells) {
            if (prevCell == null || !CellUtil.matchingColumn(prevCell, (Cell)cell)) {
                versions = 1;
                l.add(cell);
            } else if (++versions <= maxVersions && prevCell.getTimestamp() != cell.getTimestamp()) {
                l.add(cell);
            }
            prevCell = cell;
        }
        Cell[] result = new Cell[l.size()];
        l.toArray(result);
        return Result.create(result);
    }
}

