/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MergeScanner;
import org.apache.hadoop.hbase.client.RawAsyncLayeredTableImpl;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class RawAsyncColdTableImpl
extends RawAsyncLayeredTableImpl {
    protected RawAsyncLayeredTableImpl hotTable;
    protected long hotTtl = -1L;

    RawAsyncColdTableImpl(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder, TableName hotTableName, long hotTtl) {
        super(conn, builder);
        this.hotTtl = hotTtl;
        this.hotTable = (RawAsyncLayeredTableImpl)conn.getTable(hotTableName);
    }

    @Override
    public ResultScanner getScanner(Scan scan) {
        Scan hotScan = null;
        try {
            hotScan = ClientUtil.makeHotTableScan(scan, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new MergeScanner(scan, this.hotTable.getRawScanner(hotScan), this.getRawScanner(scan));
    }

    @Override
    public CompletableFuture<Result> get(Get get) {
        Get hotGet = null;
        try {
            hotGet = ClientUtil.makeHotTableGet(get, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.rawGet(get).thenCombine(this.hotTable.rawGet(hotGet), (hotr, coldr) -> MergeScanner.mergeResultsOfSameRow(hotr, coldr, get.getMaxVersions()));
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        List<Get> hotGets = null;
        try {
            hotGets = ClientUtil.makeHotTableGets(gets, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        List<CompletableFuture<Result>> r1 = this.rawGet(gets);
        ArrayList<CompletableFuture<Result>> results = new ArrayList<CompletableFuture<Result>>(r1.size());
        List<CompletableFuture<Result>> r2 = this.hotTable.rawGet(hotGets);
        for (int i = 0; i < gets.size(); ++i) {
            int idx = i;
            CompletionStage r = r1.get(i).thenCombine(r2.get(i), (rr1, rr2) -> MergeScanner.mergeResultsOfSameRow(rr1, rr2, ((Get)gets.get(idx)).getMaxVersions()));
            results.add(i, (CompletableFuture<Result>)r);
        }
        return results;
    }
}

