/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientUtil {
    public static boolean areScanStartRowAndStopRowEqual(byte[] startRow, byte[] stopRow) {
        return startRow != null && startRow.length > 0 && Bytes.equals((byte[])startRow, (byte[])stopRow);
    }

    public static Cursor createCursor(byte[] row) {
        return new Cursor(row);
    }

    public static Pair<TableDescriptor, TableDescriptor> makeLayeredTableDescripter(TableDescriptor hot, TableDescriptor cold, long ttl) {
        TableDescriptor newHot = TableDescriptorBuilder.newBuilder(hot).setValue("hbase.hstore.engine.class", HConstants.TRANSFER_STOREENGINE_CLASS).setValue(HConstants.SINK_TABLE_NAME, cold.getTableName().toString()).setValue(HConstants.SOURCE_TTL, String.valueOf(ttl)).build();
        TableDescriptor newCold = TableDescriptorBuilder.newBuilder(cold).setValue(HConstants.SOURCE_TABLE_NAME, hot.getTableName().toString()).setValue("HFILE_STORAGE_POLICY", "COLD").setMaxFileSize(0xC80000000L).setValue("hbase.hstore.blockingStoreFiles", String.valueOf(54)).build();
        return new Pair((Object)newHot, (Object)newCold);
    }

    public static Scan removeColdDataFromScan(Scan scan, long hotTtl) throws IOException {
        long minTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        Scan hotScan = new Scan(scan);
        TimeRange tr = hotScan.getTimeRange();
        if (tr.getMin() < minTimeStamp) {
            hotScan.setTimeRange(minTimeStamp, tr.getMax());
        }
        return hotScan;
    }

    public static Get removeColdDataFromGet(Get get, long hotTtl) throws IOException {
        long minTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        Get hotGet = new Get(get);
        TimeRange tr = hotGet.getTimeRange();
        if (tr.getMin() < minTimeStamp) {
            hotGet.setTimeRange(minTimeStamp, tr.getMax());
        }
        return hotGet;
    }

    public static List<Get> removeColdDataFromGets(List<Get> gets, long hotTtl) throws IOException {
        LinkedList<Get> hotGets = new LinkedList<Get>();
        long minTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        for (Get get : gets) {
            Get hotGet = new Get(get);
            TimeRange tr = hotGet.getTimeRange();
            if (tr.getMin() < minTimeStamp) {
                hotGet.setTimeRange(minTimeStamp, tr.getMax());
            }
            hotGets.add(hotGet);
        }
        return hotGets;
    }

    public static Scan makeHotTableScan(Scan scan, long hotTtl) throws IOException {
        long maxTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        Scan hotScan = new Scan(scan);
        TimeRange tr = hotScan.getTimeRange();
        if (tr.getMax() > maxTimeStamp) {
            hotScan.setTimeRange(tr.getMin(), maxTimeStamp);
        }
        return hotScan;
    }

    public static Get makeHotTableGet(Get get, long hotTtl) throws IOException {
        long maxTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        Get hotGet = new Get(get);
        TimeRange tr = hotGet.getTimeRange();
        if (tr.getMax() > maxTimeStamp) {
            hotGet.setTimeRange(tr.getMin(), maxTimeStamp);
        }
        return hotGet;
    }

    public static List<Get> makeHotTableGets(List<Get> gets, long hotTtl) throws IOException {
        LinkedList<Get> hotGets = new LinkedList<Get>();
        long maxTimeStamp = System.currentTimeMillis() - hotTtl * 1000L;
        for (Get get : gets) {
            Get hotGet = new Get(get);
            TimeRange tr = hotGet.getTimeRange();
            if (tr.getMax() > maxTimeStamp) {
                hotGet.setTimeRange(tr.getMin(), maxTimeStamp);
            }
            hotGets.add(hotGet);
        }
        return hotGets;
    }
}

