/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil2;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class VHostMapListener
extends ZooKeeperListener {
    static final Log LOG = LogFactory.getLog(VHostMapListener.class);
    private String node;
    private Map<String, String> vhostMap;
    public static final Map<HConnectionKey, VHostMapListener> VHOST_INSTANCES;
    public static final int MAX_CACHED_VHOSTMAP_INSTANCES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VHostMapListener getInstance(String root, Configuration conf) {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        VHostMapListener instance = null;
        Map<HConnectionKey, VHostMapListener> map = VHOST_INSTANCES;
        synchronized (map) {
            instance = VHOST_INSTANCES.get(connectionKey);
            if (instance == null) {
                try {
                    instance = new VHostMapListener(root, new ZooKeeperWatcher(conf, "VHostMapListener", null));
                    VHOST_INSTANCES.put(connectionKey, instance);
                }
                catch (IOException e) {
                    LOG.warn((Object)"vhostmap listener create failed,will not enable pub-conn.");
                }
            }
        }
        return instance;
    }

    private VHostMapListener(String path, ZooKeeperWatcher watcher) {
        super(watcher);
        this.node = path;
        this.vhostMap = new HashMap<String, String>();
        this.init();
    }

    private void init() {
        try {
            ZKUtil2.createWithParents(this.watcher, this.node);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"create vhost root node failed, pub-network still disabled.", (Throwable)e);
            return;
        }
        this.watcher.registerListener(this);
        this.updateVhostMap();
    }

    private void watchUpdate() {
        try {
            ZKUtil2.watchAndCheckExists(this.watcher, this.node);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"watch vhost node failed, vhostmap will not update later.", (Throwable)e);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (!path.startsWith(this.node)) {
            return;
        }
        this.updateVhostMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVhostMap() {
        block6: {
            try {
                List<String> children = ZKUtil2.listChildrenAndWatchThem(this.watcher, this.node);
                if (children == null || children.size() <= 0) break block6;
                Map<String, String> map = this.vhostMap;
                synchronized (map) {
                    this.vhostMap.clear();
                    for (String childNode : children) {
                        byte[] data = ZKUtil2.getDataAndWatch(this.watcher, ZKUtil2.joinZNode(this.node, childNode));
                        if (data == null || data.length <= 0) continue;
                        String child = Bytes.toString((byte[])data);
                        this.vhostMap.put(childNode, child);
                    }
                }
            }
            catch (KeeperException e) {
                LOG.warn((Object)("encount error while getting data from " + this.node));
                e.printStackTrace();
            }
        }
        this.watchUpdate();
    }

    public String getVhost(String host) {
        return this.vhostMap.get(host);
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vhostMap=[ ");
        for (Map.Entry<String, String> e : this.vhostMap.entrySet()) {
            sb.append(e.getKey() + ":" + e.getValue() + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        MAX_CACHED_VHOSTMAP_INSTANCES = HBaseConfiguration.create().getInt("hbase.vhostmap.instances.cache.max", 100) + 1;
        VHOST_INSTANCES = new LinkedHashMap<HConnectionKey, VHostMapListener>((int)((float)MAX_CACHED_VHOSTMAP_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, VHostMapListener> eldest) {
                return this.size() > MAX_CACHED_VHOSTMAP_INSTANCES;
            }
        };
    }
}

