/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;

public class BigDecimalWritable
implements WritableComparable<BigDecimalWritable> {
    private BigDecimal value;

    public BigDecimalWritable() {
        this.value = BigDecimal.ZERO;
    }

    public BigDecimalWritable(BigDecimal bi) {
        this.value = bi;
    }

    public void set(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal get() {
        return this.value;
    }

    @Override
    public int compareTo(BigDecimalWritable o) {
        return this.value.compareTo(o.get());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BigDecimalWritable)) {
            return false;
        }
        return this.compareTo((BigDecimalWritable)o) == 0;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = new BigDecimal(Text.readString(in));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.value.toPlainString());
    }

    static {
        WritableComparator.define(BigDecimalWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BigDecimalWritable thisValue = new BigDecimalWritable();
        private BigDecimalWritable thatValue = new BigDecimalWritable();

        public Comparator() {
            super(BigDecimalWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                this.thisValue.readFields(new DataInputStream(new ByteArrayInputStream(b1, s1, l1)));
                this.thatValue.readFields(new DataInputStream(new ByteArrayInputStream(b2, s2, l2)));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read field from byte array: " + e);
            }
            return this.thisValue.compareTo(this.thatValue);
        }
    }
}

