/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FloatWritable
implements WritableComparable<FloatWritable> {
    private float value = 0.0f;

    public FloatWritable() {
    }

    public FloatWritable(float value) {
        this.set(value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    public void set(float value) {
        this.value = value;
    }

    public float get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.value == ((FloatWritable)o).value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(FloatWritable o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    static {
        WritableComparator.define(FloatWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(FloatWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float thatValue;
            float thisValue = Comparator.readFloat(b1, s1);
            return thisValue < (thatValue = Comparator.readFloat(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

