/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShortWritable
implements WritableComparable<ShortWritable> {
    private short value;

    public ShortWritable() {
    }

    public ShortWritable(short value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readShort();
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.value == ((ShortWritable)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    @Override
    public int compareTo(ShortWritable o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }

    public short get() {
        return this.value;
    }

    public void set(short value) {
        this.value = value;
    }

    static {
        WritableComparator.define(ShortWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ShortWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            short thatValue;
            short thisValue = Comparator.readShort(b1, s1);
            return thisValue < (thatValue = Comparator.readShort(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

