/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;

public class MachineList
implements Serializable {
    private static final long serialVersionUID = -1098681309764178588L;
    protected ArrayList<String> machineList = new ArrayList();

    public MachineList() {
    }

    public MachineList(ArrayList<String> machineList) {
        this.SetMachineList(machineList);
    }

    public MachineList(MachineList machineList) throws LogException {
        this.SetMachineList(machineList.GetMachineList());
    }

    public ArrayList<String> GetMachineList() {
        return this.machineList;
    }

    public void SetMachineList(ArrayList<String> machineList) {
        this.machineList = new ArrayList();
        for (String machine : machineList) {
            this.machineList.add(machine);
        }
    }

    public void SetMachineList(JSONArray machineListJSONArray) throws LogException {
        this.machineList = new ArrayList();
        for (int i = 0; i < machineListJSONArray.size(); ++i) {
            String machine = machineListJSONArray.getString(i);
            this.machineList.add(machine);
        }
    }

    private JSONArray ToRequestJson() {
        JSONArray machineList = new JSONArray();
        for (String machine : this.GetMachineList()) {
            machineList.add((Object)machine);
        }
        return machineList;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public void FromJsonArray(JSONArray array) throws LogException {
        try {
            this.SetMachineList(array);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineList", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String machineListString) throws LogException {
        try {
            JSONArray machineArray = JSONArray.fromObject((Object)machineListString);
            this.FromJsonArray(machineArray);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineGroup", e.getMessage(), e, "");
        }
    }
}

