package com.atlassian.cache.impl;

import javax.annotation.Nonnull;

import com.atlassian.cache.CacheEntryEvent;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A default implementation for {@code CacheEntryEvent}
 */
public class DefaultCacheEntryEvent<K, V> implements CacheEntryEvent<K, V>
{
    private final K key;
    private final V value;
    private final V oldValue;

    public DefaultCacheEntryEvent(@Nonnull K key, V value, V oldValue)
    {
        this.key = checkNotNull(key);
        this.value = value;
        this.oldValue = oldValue;
    }

    @Override
    @Nonnull
    public K getKey()
    {
        return key;
    }

    @Override
    public V getValue()
    {
        return value;
    }

    @Override
    public V getOldValue()
    {
        return oldValue;
    }
}
