/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.permissions.ContentRestrictionsPageResponse;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.rest.api.model.RestList;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.std.SerializerBase;

public class PageResponseSerializer
extends SerializerBase<PageResponse<?>> {
    public PageResponseSerializer() {
        super(PageResponse.class, false);
    }

    public void serialize(PageResponse<?> value, JsonGenerator jsonGen, SerializerProvider provider) throws IOException {
        SearchPageResponse resp;
        jsonGen.writeStartObject();
        jsonGen.writeArrayFieldStart("results");
        for (Object result : value.getResults()) {
            jsonGen.writeObject(result);
        }
        jsonGen.writeEndArray();
        PageRequest pageRequest = value.getPageRequest();
        if (pageRequest != null) {
            jsonGen.writeObjectField("start", (Object)pageRequest.getStart());
            jsonGen.writeObjectField("limit", (Object)pageRequest.getLimit());
        }
        jsonGen.writeObjectField("size", (Object)value.getResults().size());
        if (value instanceof SearchPageResponse) {
            resp = (SearchPageResponse)value;
            jsonGen.writeObjectField("totalSize", (Object)resp.totalSize());
            jsonGen.writeObjectField("searchDuration", (Object)resp.getSearchDuration());
            jsonGen.writeObjectField("cqlQuery", (Object)resp.getCqlQuery());
            if (resp.getArchivedResultCount().isDefined()) {
                jsonGen.writeObjectField("archivedResultCount", resp.getArchivedResultCount().get());
            }
        }
        if (value instanceof ContentRestrictionsPageResponse) {
            resp = (ContentRestrictionsPageResponse)value;
            jsonGen.writeObjectField("restrictionsHash", (Object)resp.getRestrictionsHash());
        }
        if (value instanceof RestList) {
            RestList restList = (RestList)value;
            for (Map.Entry prop : restList.getProperties().entrySet()) {
                jsonGen.writeFieldName((String)prop.getKey());
                jsonGen.writeObject(prop.getValue());
            }
        }
        jsonGen.writeEndObject();
        jsonGen.flush();
    }
}

