/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.rest.api.model.RestList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.std.ContainerDeserializerBase;
import org.codehaus.jackson.type.JavaType;

public class RestListDeserializer
extends ContainerDeserializerBase {
    private final JsonDeserializer contentDeserializer;
    private final JavaType contentType;
    private final TypeDeserializer elementTypeDeserializer;

    public RestListDeserializer(JsonDeserializer elementDeserializer, JavaType contentType, TypeDeserializer elementTypeDeserializer) {
        super(PageResponse.class);
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.contentDeserializer = (JsonDeserializer)Preconditions.checkNotNull((Object)elementDeserializer);
        this.contentType = (JavaType)Preconditions.checkNotNull((Object)contentType);
    }

    public JavaType getContentType() {
        return this.contentType;
    }

    public JsonDeserializer<Object> getContentDeserializer() {
        return this.contentDeserializer;
    }

    public PageResponse deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        int start = 0;
        Integer limit = null;
        boolean hasMore = false;
        ImmutableList.Builder results = null;
        JsonToken token = jsonParser.getCurrentToken();
        int openObjectCount = 0;
        if (JsonToken.START_ARRAY.equals((Object)token)) {
            results = ImmutableList.builder();
            this.deserializeArray(jsonParser, deserializationContext, results);
        } else if (JsonToken.START_OBJECT.equals((Object)token)) {
            do {
                if (token == JsonToken.END_OBJECT) {
                    --openObjectCount;
                } else if (token == JsonToken.START_OBJECT) {
                    ++openObjectCount;
                }
                if (openObjectCount == 0) break;
                String name = jsonParser.getCurrentName();
                if ("results".equalsIgnoreCase(name) || "nodes".equalsIgnoreCase(name)) {
                    results = ImmutableList.builder();
                    token = jsonParser.nextToken();
                    Preconditions.checkState((boolean)token.equals((Object)JsonToken.START_ARRAY));
                    this.deserializeArray(jsonParser, deserializationContext, results);
                    continue;
                }
                if ("start".equalsIgnoreCase(name)) {
                    jsonParser.nextToken();
                    start = jsonParser.getIntValue();
                    continue;
                }
                if ("limit".equalsIgnoreCase(name)) {
                    jsonParser.nextToken();
                    limit = jsonParser.getIntValue();
                    continue;
                }
                if ("hasMore".equalsIgnoreCase(name)) {
                    jsonParser.nextToken();
                    hasMore = jsonParser.getBooleanValue();
                    continue;
                }
                if ("pageInfo".equalsIgnoreCase(name)) {
                    jsonParser.nextToken();
                    JsonNode pageInfo = jsonParser.readValueAsTree();
                    hasMore = pageInfo.get("hasNextPage").asBoolean();
                    continue;
                }
                if (!"next".equalsIgnoreCase(name)) continue;
                jsonParser.nextToken();
                jsonParser.nextTextValue();
                hasMore = true;
            } while ((token = jsonParser.nextToken()) != null);
        }
        if (results == null) {
            return null;
        }
        ImmutableList resultList = results.build();
        if (limit == null) {
            limit = resultList.size();
        }
        SimplePageRequest request = new SimplePageRequest(start, limit.intValue());
        return RestList.createRestList((PageRequest)request, (List)resultList, (boolean)hasMore);
    }

    private void deserializeArray(JsonParser jsonParser, DeserializationContext deserializationContext, ImmutableList.Builder results) throws IOException {
        JsonToken token;
        while ((token = jsonParser.nextToken()) != JsonToken.END_ARRAY && token != null) {
            Preconditions.checkState((boolean)token.equals((Object)JsonToken.START_OBJECT));
            results.add(this.deserializeNextElement(jsonParser, deserializationContext));
        }
    }

    private Object deserializeNextElement(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this.elementTypeDeserializer == null) {
            return this.contentDeserializer.deserialize(jsonParser, deserializationContext);
        }
        return this.contentDeserializer.deserializeWithType(jsonParser, deserializationContext, this.elementTypeDeserializer);
    }
}

