/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import com.atlassian.hibernate.extras.ResettableTableHiLoGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class ResettableHiLoGeneratorHelper {
    private static final Logger log = LoggerFactory.getLogger(ResettableHiLoGeneratorHelper.class);
    private static final String HIBERNATE_UNIQUE_KEY_TABLE = "hibernate_unique_key";
    private static final String HIBERNATE_UNIQUE_KEY_COLUMN = "next_hi";
    private final SessionFactory sessionFactory;

    public ResettableHiLoGeneratorHelper(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextHiValue() throws HibernateException, SQLException {
        Connection connection = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true).connection();
        try {
            HashSet<ResettableTableHiLoGenerator> generators = new HashSet<ResettableTableHiLoGenerator>();
            Statement statement = connection.createStatement();
            try {
                long maximumId = 0L;
                int maxLo = 0;
                for (Object o : this.sessionFactory.getAllClassMetadata().keySet()) {
                    Class c = (Class)o;
                    String className = c.toString();
                    ClassPersister persister = ((SessionFactoryImplementor)this.sessionFactory).getPersister(c);
                    IdentifierGenerator identifierGenerator = persister.getIdentifierGenerator();
                    if (!(persister instanceof EntityPersister) || !(identifierGenerator instanceof ResettableTableHiLoGenerator)) continue;
                    EntityPersister entityPersister = (EntityPersister)persister;
                    ResettableTableHiLoGenerator generator = (ResettableTableHiLoGenerator)identifierGenerator;
                    generators.add(generator);
                    if (maxLo == 0) {
                        maxLo = generator.getMaxLo();
                    } else if (maxLo != generator.getMaxLo()) {
                        throw new IllegalStateException("One generator uses " + maxLo + " for maxLo, generator for " + className + " uses " + generator.getMaxLo());
                    }
                    String[] idColumnNames = entityPersister.getIdentifierColumnNames();
                    if (idColumnNames.length != 1) {
                        throw new IllegalStateException("expected a single id column for " + className + " found " + idColumnNames.length);
                    }
                    ResultSet rs = statement.executeQuery("select max(" + idColumnNames[0] + ") from " + entityPersister.getTableName());
                    try {
                        if (!rs.next()) continue;
                        long value = rs.getLong(1);
                        log.info("Maximum id for " + className + " is " + value);
                        if (value <= maximumId) continue;
                        maximumId = value;
                    }
                    finally {
                        JdbcUtils.closeResultSet((ResultSet)rs);
                    }
                }
                int nextHi = (int)(maximumId / (long)(maxLo + 1)) + 1;
                log.info("Setting new next_hi to " + nextHi);
                if (statement.executeUpdate("update hibernate_unique_key set next_hi = " + nextHi) == 0 && statement.executeUpdate("insert into hibernate_unique_key values(" + nextHi + ")") == 0) {
                    throw new IllegalStateException("failed to insert initial next_hi value");
                }
            }
            finally {
                JdbcUtils.closeStatement((Statement)statement);
            }
            for (ResettableTableHiLoGenerator generator : generators) {
                generator.reset();
            }
            connection.commit();
        }
        catch (HibernateException exception) {
            connection.rollback();
            throw exception;
        }
        catch (SQLException exception) {
            connection.rollback();
            throw exception;
        }
        catch (RuntimeException exception) {
            connection.rollback();
            throw exception;
        }
        catch (Error error) {
            connection.rollback();
            throw error;
        }
    }
}

