/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import com.atlassian.hibernate.extras.ExportHibernateHandle;
import com.atlassian.hibernate.extras.ExportProgress;
import com.atlassian.hibernate.extras.HibernateTranslator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.BagType;
import net.sf.hibernate.type.DateType;
import net.sf.hibernate.type.ListType;
import net.sf.hibernate.type.MapType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.SetType;
import net.sf.hibernate.type.TimestampType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public abstract class XMLDatabinder {
    private static final Logger log = LoggerFactory.getLogger(XMLDatabinder.class);
    public static final String ISO_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    private SessionFactoryImplementor factory;
    protected Set<ExportHibernateHandle> handles = new HashSet<ExportHibernateHandle>();
    protected Set<ExportHibernateHandle> bucketHandles = new HashSet<ExportHibernateHandle>();
    protected Set<ExportHibernateHandle> excludedHandles = new HashSet<ExportHibernateHandle>();
    protected Set<ExportHibernateHandle> nextHandles = new HashSet<ExportHibernateHandle>();
    protected Set<ExportHibernateHandle> processedHandles = new HashSet<ExportHibernateHandle>();
    protected String encoding;
    private final HibernateTranslator translator;
    private DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat isoTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private ExportProgress progress;
    protected static final String LEFT_CHEVRON = "<";
    protected static final String RIGHT_CHEVRON = ">";
    protected static final String CARRIAGE_RETURN = "\n";
    protected static final String START_CLOSE_TAG = "</";
    protected static final String END_TAG_CARRIAGE_RETURN = ">\n";
    private static final String CONST_NAME = "name";
    private static final String CONST_CLASS = "class";
    private static final String CONST_PACKAGE = "package";
    private static final String CONST_ENUM_CLASS = "enum-class";
    private static final String CONST_COMPOSITE_ELEMENT = "composite-element";
    private static final String CONST_ELEMENT = "element";
    private static final String CONST_SUBCOLLECTION = "subcollection";
    private static final String CONST_ID = "id";
    private static final String CONST_COMPOSITE_ID = "composite-id";
    private static final String CONST_OPEN_OBJECT_TAG = "<object";
    private static final String CONST_CLOSE_OBJECT_TAG = "</object>\n";
    private static final String CONST_COLLECTION = "collection";
    private static final String CONST_PROPERTY = "property";
    private static final String CONST_COMPONENT = "component";
    private static final String CONST_TYPE = "type";
    protected static final String CONST_OPEN_CDATA = "<![CDATA[";
    protected static final String CONST_CLOSE_CDATA = "]]>";
    private Session session;
    private Transaction tx;
    private Collection<Class<?>> classesExcludedFromEntityExport = new ArrayList();
    private Collection<Class<?>> classesExcludedFromReferenceExport = new ArrayList();

    public XMLDatabinder(SessionFactoryImplementor factory, String encoding, HibernateTranslator translator) {
        this.factory = factory;
        this.encoding = encoding;
        this.translator = translator;
    }

    private ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    private void objectWritten(ExportHibernateHandle handle) throws HibernateException {
        if (this.progress.increment() % 500 == 0) {
            this.commit();
        }
        this.processedHandles.add(handle);
    }

    private void commit() throws HibernateException {
        this.session.flush();
        this.session.clear();
        this.tx.commit();
        this.tx = this.session.beginTransaction();
    }

    private void startTxn() throws HibernateException {
        this.session = SessionFactoryUtils.getSession((SessionFactory)this.factory, (boolean)true);
        this.tx = this.session.beginTransaction();
        this.commit();
    }

    public void toGenericXML(Writer writer, ExportProgress progressMeter) throws HibernateException, IOException {
        this.progress = progressMeter;
        this.startTxn();
        writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        String date = Hibernate.TIMESTAMP.toString((Object)new Date(), this.factory);
        writer.write("<hibernate-generic datetime=\"" + date + "\">\n");
        this.progress.setTotal(this.handles.size() + this.bucketHandles.size() + 2);
        this.progress.setStatus("Writing export");
        while (!this.handles.isEmpty()) {
            this.writeObjects(writer, this.handles);
            this.handles = this.nextHandles;
            this.nextHandles = new HashSet<ExportHibernateHandle>();
        }
        this.writeObjects(writer, this.bucketHandles);
        writer.write("</hibernate-generic>");
        this.commit();
    }

    private void writeObjects(Writer writer, Iterable<ExportHibernateHandle> iter) throws IOException, HibernateException {
        for (ExportHibernateHandle handle : iter) {
            if (this.isExcludedOrProcessed(handle)) {
                this.progress.increment();
                continue;
            }
            Object object = this.translator.handleToObject(handle);
            if ((object = this.maybeInitializeIfProxy(object)) != null) {
                writer.write(CONST_OPEN_OBJECT_TAG);
                this.addClass(writer, object.getClass(), CONST_CLASS, CONST_PACKAGE);
                writer.write(END_TAG_CARRIAGE_RETURN);
                ClassPersister persister = this.getPersister(object.getClass());
                if (log.isDebugEnabled()) {
                    log.debug("Writing object: " + persister.getClassName() + " with ID: " + persister.getIdentifier(object) + " to XML.");
                }
                if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                    Serializable id = persister.getIdentifier(object);
                    this.renderProperty(writer, persister.getIdentifierPropertyName(), persister.getIdentifierType(), id, CONST_COMPOSITE_ID, CONST_ID, null, false);
                }
                Type[] types = persister.getPropertyTypes();
                Object[] values = persister.getPropertyValues(object);
                String[] names = persister.getPropertyNames();
                for (int i = 0; i < types.length; ++i) {
                    block10: {
                        try {
                            if (this.isExcludedAsProperty(types[i], values[i])) {
                            }
                            break block10;
                        }
                        catch (RuntimeException onfe) {
                            log.warn("Object doesn't exist for property " + names[i] + " of " + handle.toString(), onfe.getCause());
                        }
                        continue;
                    }
                    this.renderProperty(writer, names[i], types[i], values[i], CONST_COMPONENT, CONST_PROPERTY, CONST_COLLECTION, false);
                }
                writer.write(CONST_CLOSE_OBJECT_TAG);
            } else {
                log.warn("Null object found for key:" + handle.toString());
            }
            this.objectWritten(handle);
        }
    }

    private boolean isExcludedOrProcessed(ExportHibernateHandle handle) {
        if (this.excludedHandles.contains(handle)) {
            return true;
        }
        if (this.processedHandles.contains(handle)) {
            return true;
        }
        Class handleClass = handle.getClazz();
        if (handleClass.isEnum()) {
            return true;
        }
        return this.classExtendsOneOf(handleClass, this.classesExcludedFromEntityExport);
    }

    private boolean classExtendsOneOf(Class clazz, Collection<Class<?>> classes) {
        for (Class<?> listedClass : classes) {
            if (!listedClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private void addClass(Writer writer, Class clazz, String classAttributeName, String packageAttributeName) throws IOException {
        String className = clazz.getName();
        String unqualifiedClassName = StringHelper.unqualify((String)className);
        String packageName = StringHelper.qualifier((String)className);
        this.appendAttribute(writer, classAttributeName, unqualifiedClassName);
        this.appendAttribute(writer, packageAttributeName, packageName);
    }

    private Object maybeInitializeIfProxy(Object object) {
        if (!(object instanceof HibernateProxy)) {
            return object;
        }
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)((HibernateProxy)object));
        return li.getImplementation();
    }

    public XMLDatabinder bind(Object object) {
        this.handles.add(this.translator.objectOrHandleToHandle(object));
        return this;
    }

    public XMLDatabinder unbind(Object object) {
        this.excludedHandles.add(this.translator.objectOrHandleToHandle(object));
        return this;
    }

    public XMLDatabinder bindAll(Collection objects) {
        for (Object object : objects) {
            this.bind(object);
        }
        return this;
    }

    public XMLDatabinder unbindAll(Collection objects) {
        for (Object object : objects) {
            this.unbind(object);
        }
        return this;
    }

    private void renderProperty(Writer writer, String name, Type type, Object value, String componentName, String propertyName, String collectionName, boolean doType) throws HibernateException, IOException {
        if (type.isComponentType()) {
            this.renderComponentType(writer, name, type, value, componentName);
        } else if (type.isPersistentCollectionType()) {
            this.renderCollectionType(writer, name, type, value, collectionName);
        } else if (type.isEntityType()) {
            this.renderEntityType(writer, name, type, value, propertyName);
            if (!this.isExcludedAsProperty(value)) {
                this.associatedObjectFound(value);
            }
        } else if (type.getReturnedClass().isEnum()) {
            this.renderEnumType(writer, name, type, value, propertyName);
        } else {
            this.renderOtherType(writer, name, type, value, propertyName, doType);
        }
    }

    private void renderOtherType(Writer writer, String name, Type type, Object value, String propertyName, boolean doType) throws HibernateException, IOException {
        writer.write(LEFT_CHEVRON + propertyName);
        if (name != null) {
            this.appendAttribute(writer, CONST_NAME, name);
        }
        if (doType) {
            this.appendAttribute(writer, CONST_TYPE, type.getName());
        }
        if (value != null) {
            writer.write(RIGHT_CHEVRON);
            String xmlValue = type.toString(value, this.factory);
            if (!this.parseCustomType(writer, type, value, xmlValue)) {
                if (type instanceof TimestampType) {
                    writer.write(this.isoTimestampFormat.format((Date)value));
                } else if (type instanceof DateType) {
                    writer.write(this.isoDateFormat.format((Date)value));
                } else {
                    writer.write(xmlValue);
                }
            }
            writer.write(START_CLOSE_TAG + propertyName + END_TAG_CARRIAGE_RETURN);
        } else {
            writer.write("/>");
        }
    }

    public abstract boolean parseCustomType(Writer var1, Type var2, Object var3, String var4) throws IOException;

    private void renderEnumType(Writer writer, String name, Type type, Object value, String propertyName) throws HibernateException, IOException {
        writer.write(LEFT_CHEVRON + propertyName);
        if (name != null) {
            this.appendAttribute(writer, CONST_NAME, name);
        }
        this.addClass(writer, type.getReturnedClass(), CONST_ENUM_CLASS, CONST_PACKAGE);
        if (value != null) {
            writer.write(RIGHT_CHEVRON);
            String xmlValue = type.toString(value, this.factory);
            writer.write(xmlValue);
            writer.write(START_CLOSE_TAG + propertyName + END_TAG_CARRIAGE_RETURN);
        } else {
            writer.write("/>");
        }
    }

    private void appendAttribute(Writer writer, String attributeName, String attributeValue) throws IOException {
        writer.write(" " + attributeName + "=\"" + attributeValue + "\"");
    }

    private void renderEntityType(Writer writer, String name, Type type, Object value, String propertyName) throws HibernateException, IOException {
        if ((value = this.maybeInitializeIfProxy(value)) != null) {
            writer.write(LEFT_CHEVRON + propertyName);
            if (name != null) {
                this.appendAttribute(writer, CONST_NAME, name);
            }
            this.addClass(writer, value.getClass(), CONST_CLASS, CONST_PACKAGE);
            writer.write(RIGHT_CHEVRON);
            ClassPersister persister = this.getPersister(value.getClass());
            if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                Type idType = persister.getIdentifierType();
                Serializable id = persister.getIdentifier(value);
                this.renderProperty(writer, persister.getIdentifierPropertyName(), idType, id, CONST_COMPOSITE_ID, CONST_ID, null, false);
            }
            writer.write(START_CLOSE_TAG + propertyName + RIGHT_CHEVRON + CARRIAGE_RETURN);
        }
    }

    private void renderCollectionType(Writer writer, String name, Type type, Object value, String collectionName) throws HibernateException, IOException {
        int length;
        PersistentCollectionType collectiontype = (PersistentCollectionType)type;
        String role = collectiontype.getRole();
        CollectionPersister persister = this.factory.getCollectionPersister(role);
        if (persister.isArray() ? (length = Array.getLength(value)) == 0 : value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        if (persister.isArray()) {
            collectionName = "array";
        }
        writer.write(LEFT_CHEVRON + collectionName);
        if (name != null) {
            this.appendAttribute(writer, CONST_NAME, name);
        }
        if (!persister.isArray()) {
            this.appendAttribute(writer, CONST_CLASS, type.getName());
        }
        Type elemType = persister.getElementType();
        writer.write(RIGHT_CHEVRON);
        if (persister.isArray()) {
            int length2 = Array.getLength(value);
            for (int i = 0; i < length2; ++i) {
                Object element = Array.get(value, i);
                this.renderProperty(writer, null, elemType, element, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, true);
                this.associatedObjectFound(element);
            }
        } else if (type instanceof ListType || type instanceof SetType || type instanceof BagType) {
            for (Object collectionItem : (Collection)value) {
                if (this.isExcludedAsProperty(elemType, collectionItem)) continue;
                this.renderProperty(writer, null, elemType, collectionItem, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, true);
            }
        } else if (type instanceof MapType) {
            Iterator i$ = ((Map)value).entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = i$.next();
                Object collectionKey = e.getKey();
                Object collectionItem = e.getValue();
                log.debug("Rendering map property: {} -> {}", collectionKey, collectionItem);
                if (this.isExcludedAsProperty(elemType, collectionItem)) continue;
                this.renderProperty(writer, collectionKey.toString(), elemType, collectionItem, CONST_COMPOSITE_ELEMENT, CONST_ELEMENT, CONST_SUBCOLLECTION, true);
            }
        }
        writer.write(START_CLOSE_TAG + collectionName + END_TAG_CARRIAGE_RETURN);
    }

    private boolean isExcludedAsProperty(Type type, Object obj) {
        return type.isEntityType() && type.isAssociationType() && this.isExcludedAsProperty(obj);
    }

    private boolean isExcludedAsProperty(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Enum) {
            return false;
        }
        ExportHibernateHandle handle = this.translator.objectToHandle(obj);
        if (this.classExtendsOneOf(handle.getClazz(), this.classesExcludedFromReferenceExport)) {
            return true;
        }
        return this.excludedHandles.contains(handle);
    }

    private void renderComponentType(Writer writer, String name, Type type, Object value, String componentName) throws HibernateException, IOException {
        if (value != null) {
            AbstractComponentType componenttype = (AbstractComponentType)type;
            writer.write(LEFT_CHEVRON + componentName);
            if (name != null) {
                this.appendAttribute(writer, CONST_NAME, name);
            }
            writer.write(RIGHT_CHEVRON);
            String[] properties = componenttype.getPropertyNames();
            Object[] subvalues = componenttype.getPropertyValues(value, null);
            Type[] subtypes = componenttype.getSubtypes();
            for (int j = 0; j < properties.length; ++j) {
                this.renderProperty(writer, properties[j], subtypes[j], subvalues[j], CONST_COMPONENT, CONST_PROPERTY, CONST_COLLECTION, true);
            }
            writer.write(START_CLOSE_TAG + componentName + END_TAG_CARRIAGE_RETURN);
        }
    }

    private void associatedObjectFound(Object object) {
        boolean addedHandle;
        ExportHibernateHandle handle;
        if (object == null) {
            return;
        }
        if ((object = this.maybeInitializeIfProxy(object)) != null && !this.isExcludedOrProcessed(handle = this.translator.objectToHandle(object)) && (addedHandle = this.nextHandles.add(handle))) {
            this.progress.incrementTotal();
        }
    }

    public void excludeClass(Class<?> clazz) {
        this.excludeClassFromEntityExport(clazz);
        this.excludeClassFromReferenceExport(clazz);
    }

    public void excludeClassFromReferenceExport(Class<?> clazz) {
        this.classesExcludedFromReferenceExport.add(clazz);
    }

    public void excludeClassFromEntityExport(Class<?> clazz) {
        this.classesExcludedFromEntityExport.add(clazz);
    }
}

