/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.TableGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableTableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private static final Logger log = LoggerFactory.getLogger(ResettableTableHiLoGenerator.class);
    private long hi;
    private int lo;
    private int maxLo;
    private Class<?> returnClass;

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt((String)MAX_LO, (Properties)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        if (this.lo > this.maxLo) {
            long hival = ((Number)super.generate(session, obj)).longValue();
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return ResettableTableHiLoGenerator.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public synchronized void reset() {
        this.lo = this.maxLo + 1;
    }

    private static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return value;
        }
        if (clazz == Integer.class) {
            return (int)value;
        }
        if (clazz == Short.class) {
            return (short)value;
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    public int getMaxLo() {
        return this.maxLo;
    }
}

