/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.tangosol;

import com.atlassian.hibernate.extras.tangosol.AtlassianHibernateCache;
import com.atlassian.hibernate.extras.tangosol.CacheEntry;
import com.atlassian.hibernate.extras.tangosol.CacheEntryProcessor;
import java.io.Serializable;
import java.util.Comparator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceCacheStrategy
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(CoherenceCacheStrategy.class);
    private AtlassianHibernateCache cache;
    private int nextLockId;

    public void setCache(Cache cache) {
        if (!(cache instanceof AtlassianHibernateCache)) {
            throw new IllegalArgumentException(cache.getClass().getName() + " does not implement " + AtlassianHibernateCache.class.getName());
        }
        this.cache = (AtlassianHibernateCache)cache;
    }

    private synchronized int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        boolean gettable;
        log.trace("Cache lookup: {}", key);
        Lockable lockable = (Lockable)this.cache.get(key);
        boolean bl = gettable = lockable != null && lockable.isGettable(txTimestamp);
        if (gettable) {
            log.trace("Cache hit: {}", key);
            return ((Item)lockable).getValue();
        }
        if (log.isTraceEnabled()) {
            if (lockable == null) {
                log.trace("Cache miss: " + key);
            } else {
                log.trace("Cached item was locked: " + key);
            }
        }
        return null;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, final Object version) throws CacheException {
        log.trace("Invalidating: {}", key);
        CacheEntryProcessor<Object, Lockable, CacheConcurrencyStrategy.SoftLock> processor = new CacheEntryProcessor<Object, Lockable, CacheConcurrencyStrategy.SoftLock>(){

            @Override
            public CacheConcurrencyStrategy.SoftLock process(CacheEntry<Object, Lockable> entry) {
                Lockable lockable = entry.getValue();
                long timeout = CoherenceCacheStrategy.this.cache.nextTimestamp() + (long)CoherenceCacheStrategy.this.cache.getTimeout();
                Lock lock = lockable == null ? new Lock(timeout, CoherenceCacheStrategy.this.nextLockId(), version) : lockable.lock(timeout, CoherenceCacheStrategy.this.nextLockId());
                entry.setValue(lock);
                return lock;
            }
        };
        return this.cache.invoke(key, processor);
    }

    public boolean put(Object key, final Object value, final long txTimestamp, final Object version, final Comparator versionComparator) throws CacheException {
        if (this.cache.containsKey(key)) {
            log.trace("Not overwriting already cached entry: {}", key);
            return false;
        }
        log.trace("Caching: {}", key);
        CacheEntryProcessor<Object, Lockable, Boolean> processor = new CacheEntryProcessor<Object, Lockable, Boolean>(){

            @Override
            public Boolean process(CacheEntry<Object, Lockable> entry) {
                boolean puttable;
                Lockable lockable = entry.getValue();
                boolean bl = puttable = lockable == null || lockable.isPuttable(txTimestamp, version, versionComparator);
                if (puttable) {
                    entry.setValue(new Item(value, CoherenceCacheStrategy.this.cache.nextTimestamp(), version));
                    log.trace("Cached: {}", entry.getKey());
                    return true;
                }
                if (log.isTraceEnabled()) {
                    if (lockable.isLock()) {
                        log.trace("Item was locked: " + entry.getKey());
                    } else {
                        log.trace("Item was already cached: " + entry.getKey());
                    }
                }
                return false;
            }
        };
        return this.cache.invoke(key, processor) == Boolean.TRUE;
    }

    private void decrementLock(CacheEntry entry, Lock lock) {
        lock.unlock(this.cache.nextTimestamp());
        entry.setValue(lock);
    }

    public void release(Object key, final CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        log.trace("Releasing: {}", key);
        CacheEntryProcessor<Object, Lockable, Void> processor = new CacheEntryProcessor<Object, Lockable, Void>(){

            @Override
            public Void process(CacheEntry<Object, Lockable> entry) {
                Lockable lockable = entry.getValue();
                if (CoherenceCacheStrategy.isLockUpToDate(clientLock, lockable)) {
                    CoherenceCacheStrategy.this.decrementLock(entry, (Lock)lockable);
                } else {
                    log.warn("Lock has expired for key [{}] of [{}] before lock release could be performed", new Object[]{entry.getKey(), lockable == null ? null : lockable.getClass()});
                    CoherenceCacheStrategy.this.clearLock(entry);
                }
                return null;
            }
        };
        this.cache.invoke(key, processor);
    }

    void clearLock(CacheEntry entry) {
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId(), null);
        lock.unlock(ts);
        entry.setValue(lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", (Throwable)e);
        }
    }

    public void afterUpdate(Object key, final Object value, final Object version, final CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        log.trace("Updating: {}", key);
        CacheEntryProcessor<Object, Lockable, Void> processor = new CacheEntryProcessor<Object, Lockable, Void>(){

            @Override
            public Void process(CacheEntry<Object, Lockable> entry) {
                Lockable lockable = entry.getValue();
                if (CoherenceCacheStrategy.isLockUpToDate(clientLock, lockable)) {
                    Lock lock = (Lock)lockable;
                    if (lock.wasLockedConcurrently()) {
                        CoherenceCacheStrategy.this.decrementLock(entry, lock);
                    } else {
                        entry.setValue(new Item(value, CoherenceCacheStrategy.this.cache.nextTimestamp(), version));
                        log.trace("Updated: {}", entry.getKey());
                    }
                } else {
                    log.warn("Lock has expired for key [{}] of [{}] version [{}] before afterUpdate could be performed", new Object[]{entry.getKey(), lockable == null ? null : lockable.getClass(), version});
                    CoherenceCacheStrategy.this.clearLock(entry);
                }
                return null;
            }
        };
        this.cache.invoke(key, processor);
    }

    public void afterInsert(Object key, final Object value, final Object version) throws CacheException {
        log.trace("Inserting: {}", key);
        CacheEntryProcessor<Object, Lockable, Void> processor = new CacheEntryProcessor<Object, Lockable, Void>(){

            @Override
            public Void process(CacheEntry<Object, Lockable> entry) {
                Lockable lockable = entry.getValue();
                if (lockable == null) {
                    entry.setValue(new Item(value, CoherenceCacheStrategy.this.cache.nextTimestamp(), version));
                    log.trace("Inserted: {}", entry.getKey());
                }
                return null;
            }
        };
        this.cache.invoke(key, processor);
    }

    public void evict(Object key) throws CacheException {
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
    }

    private static boolean isLockUpToDate(CacheConcurrencyStrategy.SoftLock clientLock, Lockable myLock) {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        if (minimalPuts) {
            throw new HibernateException("minimal puts not supported for read-write cache");
        }
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    CacheConcurrencyStrategy.SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long timeout, int id, Object version) {
            this.timeout = timeout;
            this.id = id;
            this.version = version;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        @Override
        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        @Override
        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            if (this.timeout < txTimestamp) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < txTimestamp : comparator.compare(this.version, newVersion) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        @Override
        public boolean isLock() {
            return true;
        }

        @Override
        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock[id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp + "]";
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object value, long currentTimestamp, Object version) {
            this.value = value;
            this.freshTimestamp = currentTimestamp;
            this.version = version;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id, this.version);
        }

        @Override
        public boolean isLock() {
            return false;
        }

        @Override
        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        @Override
        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, newVersion) < 0;
        }

        public String toString() {
            return "Item[version=" + this.version + ",freshTimestamp=" + this.freshTimestamp + "]";
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }
}

