package com.atlassian.mail;

/**
 * Used for maintaining thread information in sent emails.
 */
public interface MailThreader
{
    /**
     * Set the In-Reply-To header for an email, so it will appear threaded.
     * @param email The unsent mail to alter
     */
    void threadEmail(Email email);

    /**
     * Store the (MTA-allocated) Message-Id of a <em>sent</em> email, so later
     * emails 'in reply to' this can be threaded.
     * <p>
     * This is considered a bad idea for scalability because it requires applications to store details of every single outgoing email.
     * For example, see JRA-9979.
     * If you need to recognise incoming "In-Reply-To" headers, then it is preferred to use {@link #getCustomMessageId(Email)} to
     * create a parsable custom Message ID.
     *
     * @param email The sent mail whose Message-ID we should record
     *
     * @deprecated Use {@link #getCustomMessageId(Email)} instead to create a parsable custom Message ID. Since v2.5.0.
     */
    void storeSentEmail(Email email);

    /**
     * Allows this MailThreader to define a custom Message-ID to be set in the outgoing mail header.
     * <p>
     * Returning null means let the library create one automatically.
     * <p>
     * Be aware that Message-IDs must be globally unique, and can only contain a limited subset of ASCII characters.
     * <p>
     * Do not include the angle-brackets in the returned ID - these will be added for you.
     *
     * @param email the unsent email
     * @return the required custom Message-ID header, or null to let the library create one automatically.
     */
    String getCustomMessageId(Email email);
}
