/**
 * Atlassian Source Code Template.
 * User: Scott Farquhar
 * Date: Feb 19, 2003
 * Time: 6:56:26 PM
 * CVS Revision: $Revision$
 * Last CVS Commit: $Date$
 * Author of last CVS Commit: $Author$
 *
 * @author <a href="mailto:scott@atlassian.com">Scott Farquhar</a>
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.strategy.ProfilingStrategy;
import com.atlassian.util.profiling.strategy.impl.StackProfilingStrategy;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * <p>A timer stack.</p>
 * <p></p>
 * Usage:
 * <pre>
 * String logMessage = "Log message";
 * UtilTimerStack.push(logMessage);
 * try
 * {
 *   //do some code
 * }
 * finally
 * {
 *   UtilTimerStack.pop(logMessage); //this needs to be the same text as above
 * }
 * </pre>
 */
public class UtilTimerStack
{
    private static StackProfilingStrategy defaultProfilingStrategy = new StackProfilingStrategy();
    private static final ConcurrentLinkedQueue<ProfilingStrategy> strategies = new ConcurrentLinkedQueue<ProfilingStrategy>();

    public static void push(String name)
    {
        if (defaultProfilingStrategy.isEnabled())
        {
            defaultProfilingStrategy.start(name);
        }

        for (ProfilingStrategy strategy : strategies)
        {
            if (strategy.isEnabled())
            {
                strategy.start(name);
            }
        }
    }

    public static void pop(String name)
    {
        defaultProfilingStrategy.stop(name);
        for (ProfilingStrategy strategy : strategies)
        {
            strategy.stop(name);
        }
    }

    public static void add(ProfilingStrategy strategy)
    {
        if (!defaultProfilingStrategy.equals(strategy) && !strategies.contains(strategy))
        {
            strategies.add(strategy);
        }
    }

    public static void remove(ProfilingStrategy strategy)
    {
        strategies.remove(strategy);
    }

    public static StackProfilingStrategy getDefaultStrategy()
    {
        return defaultProfilingStrategy;
    }

    public static boolean isActive()
    {
        if (defaultProfilingStrategy.isEnabled())
        {
            return true;
        }
        for (ProfilingStrategy strategy : strategies)
        {
            if (strategy.isEnabled())
            {
                return true;
            }
        }
        return false;
    }
}
