/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.logging;

import com.atomikos.logging.JULLoggerFactoryDelegate;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactoryDelegate;

public final class LoggerFactory {
    static LoggerFactoryDelegate loggerFactoryDelegate;

    private LoggerFactory() {
    }

    public static final Logger createLogger(Class<?> clazz) {
        return loggerFactoryDelegate.createLogger(clazz);
    }

    static void setLoggerFactoryDelegate(LoggerFactoryDelegate loggerFactoryDelegate) {
        LoggerFactory.loggerFactoryDelegate = loggerFactoryDelegate;
    }

    private static void fallbackToDefault() {
        LoggerFactory.setLoggerFactoryDelegate(new JULLoggerFactoryDelegate());
    }

    static {
        String cname = null;
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            cname = "com.atomikos.logging.Slf4JLoggerFactoryDelegate";
        }
        catch (Throwable ex) {
            System.out.println("No org.slf4j.impl.StaticLoggerBinder found in ClassPath, trying with log4j...");
        }
        if (cname == null) {
            try {
                Class.forName("org.apache.logging.log4j.Logger");
                cname = "com.atomikos.logging.Log4j2LoggerFactoryDelegate";
            }
            catch (Throwable ex) {
                System.out.println("No org.apache.logging.log4j.Logger found found in ClassPath, trying with log4j...");
            }
        }
        if (cname == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                cname = "com.atomikos.logging.Log4JLoggerFactoryDelegate";
            }
            catch (Throwable ex) {
                System.out.println("No org.apache.log4j.Logger found found in ClassPath, falling back default...");
            }
        }
        try {
            if (cname != null) {
                Class<?> loggerClass = Class.forName(cname.trim(), true, Thread.currentThread().getContextClassLoader());
                loggerFactoryDelegate = (LoggerFactoryDelegate)loggerClass.newInstance();
            } else {
                LoggerFactory.fallbackToDefault();
            }
        }
        catch (Throwable ex) {
            LoggerFactory.fallbackToDefault();
        }
        Logger logger = LoggerFactory.createLogger(LoggerFactory.class);
        logger.logDebug("Using " + loggerFactoryDelegate + " for logging.");
    }
}

