/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private static final long serialVersionUID = 4796496938014754464L;
    private static final int DEFAULT_FORMAT = 1096044365;
    private String cachedToStringForPerformance;
    private int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;
    private final String branchQualifierStr;
    private final String globalTransactionIdStr;

    public XID(String tid, String resourceURL) {
        this.formatId = 1096044365;
        this.globalTransactionIdStr = tid;
        this.globalTransactionId = tid.toString().getBytes();
        if (this.globalTransactionId.length > 64) {
            throw new RuntimeException("Max global tid length exceeded.");
        }
        this.branchQualifierStr = resourceURL;
        this.branchQualifier = resourceURL.getBytes();
        if (this.branchQualifier.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded.");
        }
    }

    public XID(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
        this.globalTransactionIdStr = new String(xid.getGlobalTransactionId());
        this.branchQualifierStr = new String(xid.getBranchQualifier());
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XID) {
            XID xid = (XID)obj;
            return xid.getBranchQualifierAsString().equals(this.getBranchQualifierAsString()) && xid.getGlobalTransactionIdAsString().equals(this.getGlobalTransactionIdAsString());
        }
        return false;
    }

    public String toString() {
        if (this.cachedToStringForPerformance == null) {
            this.cachedToStringForPerformance = this.getGlobalTransactionIdAsString() + this.getBranchQualifierAsString();
        }
        return this.cachedToStringForPerformance;
    }

    public String getBranchQualifierAsString() {
        return this.branchQualifierStr;
    }

    public String getGlobalTransactionIdAsString() {
        return this.globalTransactionIdStr;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

