/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class GlobalConfigUtils {
    private static final Log logger = LogFactory.getLog(GlobalConfigUtils.class);
    private static final Map<String, GlobalConfig> GLOBAL_CONFIG = new ConcurrentHashMap<String, GlobalConfig>();

    public static SqlSessionFactory currentSessionFactory(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull(tableInfo, ClassUtils.getUserClass(clazz).getName() + " Not Found TableInfoCache.", new Object[0]);
        String configMark = tableInfo.getConfigMark();
        GlobalConfig mybatisGlobalConfig = GlobalConfigUtils.getGlobalConfig(configMark);
        return mybatisGlobalConfig.getSqlSessionFactory();
    }

    public static GlobalConfig defaults() {
        return new GlobalConfig().setDbConfig(new GlobalConfig.DbConfig());
    }

    public static void setGlobalConfig(Configuration configuration, GlobalConfig mybatisGlobalConfig) {
        Assert.isTrue(configuration != null && mybatisGlobalConfig != null, "Error: Could not setGlobalConfig !", new Object[0]);
        GLOBAL_CONFIG.put(configuration.toString(), mybatisGlobalConfig);
    }

    public static GlobalConfig getGlobalConfig(Configuration configuration) {
        Assert.notNull(configuration, "Error: You need Initialize MybatisConfiguration !", new Object[0]);
        return GlobalConfigUtils.getGlobalConfig(configuration.toString());
    }

    public static GlobalConfig getGlobalConfig(String configMark) {
        GlobalConfig cache = GLOBAL_CONFIG.get(configMark);
        if (cache == null) {
            logger.debug("DeBug: MyBatis Plus Global configuration Initializing !");
            GlobalConfig globalConfig = GlobalConfigUtils.defaults();
            GLOBAL_CONFIG.put(configMark, globalConfig);
            return globalConfig;
        }
        return cache;
    }

    public static DbType getDbType(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getDbType();
    }

    public static IKeyGenerator getKeyGenerator(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getKeyGenerator();
    }

    public static IdType getIdType(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getIdType();
    }

    public static boolean isMapUnderscoreToCamelCase(Configuration configuration) {
        return configuration.isMapUnderscoreToCamelCase();
    }

    public static ISqlInjector getSqlInjector(Configuration configuration) {
        GlobalConfig globalConfiguration = GlobalConfigUtils.getGlobalConfig(configuration);
        ISqlInjector sqlInjector = globalConfiguration.getSqlInjector();
        if (sqlInjector == null) {
            sqlInjector = new DefaultSqlInjector();
            globalConfiguration.setSqlInjector(sqlInjector);
        }
        return sqlInjector;
    }

    public static MetaObjectHandler getMetaObjectHandler(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getMetaObjectHandler();
    }

    public static Class getSuperMapperClass(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getSuperMapperClass();
    }

    public static boolean isRefresh(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).isRefresh();
    }

    public static Set<String> getMapperRegistryCache(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getMapperRegistryCache();
    }
}

