/*
 * Decompiled with CFR 0.152.
 */
package org.patchca.filter.library;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.patchca.color.ColorFactory;
import org.patchca.color.SingleColorFactory;
import org.patchca.filter.library.AbstractImageOp;

public class CurvesImageOp
extends AbstractImageOp {
    private float strokeMin = 2.0f;
    private float strokeMax = 4.0f;
    private ColorFactory colorFactory = new SingleColorFactory();

    public float getStrokeMin() {
        return this.strokeMin;
    }

    public void setStrokeMin(float strokeMin) {
        this.strokeMin = strokeMin;
    }

    public float getStrokeMax() {
        return this.strokeMax;
    }

    public void setStrokeMax(float strokeMax) {
        this.strokeMax = strokeMax;
    }

    public ColorFactory getColorFactory() {
        return this.colorFactory;
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    private double hermiteSpline(double x1, double a1, double x2, double a2, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double b = -a2 - 2.0 * a1 - 3.0 * x1 + 3.0 * x2;
        double a = a2 + a1 + 2.0 * x1 - 2.0 * x2;
        return a * t3 + b * t2 + a1 * t + x1;
    }

    private double catmullRomSpline(double x0, double x1, double x2, double x3, double t) {
        double a1 = (x2 - x0) / 2.0;
        double a2 = (x3 - x1) / 2.0;
        return this.hermiteSpline(x1, a1, x2, a2, t);
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int i;
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        double width = dest.getWidth();
        double height = dest.getHeight();
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Random r = new Random();
        int cp = 4 + r.nextInt(3);
        int[] xPoints = new int[cp];
        int[] yPoints = new int[cp];
        width -= 10.0;
        for (int i2 = 0; i2 < cp; ++i2) {
            xPoints[i2] = (int)(5.0 + (double)i2 * width / (double)(cp - 1));
            yPoints[i2] = (int)(height * (r.nextDouble() * 0.5 + 0.2));
        }
        int subsections = 6;
        int[] xPointsSpline = new int[(cp - 1) * subsections];
        int[] yPointsSpline = new int[(cp - 1) * subsections];
        for (i = 0; i < cp - 1; ++i) {
            double x0 = i > 0 ? (double)xPoints[i - 1] : (double)(2 * xPoints[i] - xPoints[i + 1]);
            double x1 = xPoints[i];
            double x2 = xPoints[i + 1];
            double x3 = i + 2 < cp ? (double)xPoints[i + 2] : (double)(2 * xPoints[i + 1] - xPoints[i]);
            double y0 = i > 0 ? (double)yPoints[i - 1] : (double)(2 * yPoints[i] - yPoints[i + 1]);
            double y1 = yPoints[i];
            double y2 = yPoints[i + 1];
            double y3 = i + 2 < cp ? (double)yPoints[i + 2] : (double)(2 * yPoints[i + 1] - yPoints[i]);
            for (int j = 0; j < subsections; ++j) {
                xPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(x0, x1, x2, x3, 1.0 / (double)subsections * (double)j);
                yPointsSpline[i * subsections + j] = (int)this.catmullRomSpline(y0, y1, y2, y3, 1.0 / (double)subsections * (double)j);
            }
        }
        for (i = 0; i < xPointsSpline.length - 1; ++i) {
            g2.setColor(this.colorFactory.getColor(i));
            g2.setStroke(new BasicStroke(this.strokeMin + (this.strokeMax - this.strokeMin) * r.nextFloat()));
            g2.drawLine(xPointsSpline[i], yPointsSpline[i], xPointsSpline[i + 1], yPointsSpline[i + 1]);
        }
        return src;
    }
}

