/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.schedule;

import com.dangdang.ddframe.job.api.JobScheduler;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.spring.namespace.parser.common.AbstractJobConfigurationDto;
import com.dangdang.ddframe.job.spring.schedule.SpringJobFactory;
import com.dangdang.ddframe.job.spring.util.AopTargetUtils;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringJobScheduler
extends JobScheduler
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public SpringJobScheduler(CoordinatorRegistryCenter coordinatorRegistryCenter, AbstractJobConfigurationDto jobConfigurationDto) {
        super(coordinatorRegistryCenter, jobConfigurationDto.toJobConfiguration(), new ElasticJobListener[0]);
    }

    public SpringJobScheduler(CoordinatorRegistryCenter coordinatorRegistryCenter, AbstractJobConfigurationDto jobConfigurationDto, ElasticJobListener[] elasticJobListeners) {
        super(coordinatorRegistryCenter, jobConfigurationDto.toJobConfiguration(), SpringJobScheduler.getTargetElasticJobListeners(elasticJobListeners));
    }

    private static ElasticJobListener[] getTargetElasticJobListeners(ElasticJobListener[] elasticJobListeners) {
        ElasticJobListener[] result = new ElasticJobListener[elasticJobListeners.length];
        for (int i = 0; i < elasticJobListeners.length; ++i) {
            result[i] = (ElasticJobListener)AopTargetUtils.getTarget(elasticJobListeners[i]);
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void prepareEnvironments(Properties props) {
        SpringJobFactory.setApplicationContext(this.applicationContext);
        props.put("org.quartz.scheduler.jobFactory.class", SpringJobFactory.class.getName());
    }
}

