package com.dianping.cat.consumer.problem.model.transform;

import java.util.ArrayList;
import java.util.List;
import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Entry;
import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.entity.Segment;

public class DefaultLinker implements ILinker {
   private boolean m_deferrable;

   private List<Runnable> m_deferedJobs = new ArrayList<Runnable>();

   public DefaultLinker(boolean deferrable) {
      m_deferrable = deferrable;
   }

   public void finish() {
      for (Runnable job : m_deferedJobs) {
         job.run();
      }
   }

   @Override
   public boolean onDuration(final Entry parent, final Duration duration) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addDuration(duration);
            }
         });
      } else {
         parent.addDuration(duration);
      }

      return true;
   }

   @Override
   public boolean onDuration(final Entity parent, final Duration duration) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addDuration(duration);
            }
         });
      } else {
         parent.addDuration(duration);
      }

      return true;
   }

   @Override
   public boolean onEntity(final Machine parent, final Entity entity) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addEntity(entity);
            }
         });
      } else {
         parent.addEntity(entity);
      }

      return true;
   }

   @Override
   public boolean onEntry(final Machine parent, final Entry entry) {
      parent.addEntry(entry);
      return true;
   }

   @Override
   public boolean onMachine(final ProblemReport parent, final Machine machine) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addMachine(machine);
            }
         });
      } else {
         parent.addMachine(machine);
      }

      return true;
   }

   @Override
   public boolean onSegment(final JavaThread parent, final Segment segment) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addSegment(segment);
            }
         });
      } else {
         parent.addSegment(segment);
      }

      return true;
   }

   @Override
   public boolean onThread(final Entry parent, final JavaThread thread) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addThread(thread);
            }
         });
      } else {
         parent.addThread(thread);
      }

      return true;
   }

   @Override
   public boolean onThread(final Entity parent, final JavaThread thread) {
      if (m_deferrable) {
         m_deferedJobs.add(new Runnable() {
            @Override
            public void run() {
               parent.addThread(thread);
            }
         });
      } else {
         parent.addThread(thread);
      }

      return true;
   }
}
