/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemManager
implements Initializable {
    @Inject
    private ServerConfigManager m_configManager;
    private String m_defaultBaseDir;
    private Map<String, FileSystem> m_fileSystems = new HashMap<String, FileSystem>();
    private Configuration m_config;

    public long getFileMaxSize(String id) {
        return this.m_configManager.getHdfsFileMaxSize(id);
    }

    public FileSystem getFileSystem(String id, StringBuilder basePath) throws IOException {
        String serverUri = this.m_configManager.getHdfsServerUri(id);
        String baseDir = this.m_configManager.getHdfsBaseDir(id);
        FileSystem fs = this.m_fileSystems.get(id);
        if (serverUri == null || !serverUri.startsWith("hdfs:")) {
            if (fs == null) {
                fs = FileSystem.getLocal((Configuration)this.m_config);
                this.m_fileSystems.put(id, fs);
            }
            basePath.append(this.m_defaultBaseDir).append("/");
            if (baseDir == null) {
                basePath.append(id);
            } else {
                basePath.append(baseDir);
            }
        } else {
            if (fs == null) {
                URI uri = URI.create(serverUri);
                fs = FileSystem.get((URI)uri, (Configuration)this.m_config);
                this.m_fileSystems.put(id, fs);
            }
            if (baseDir == null) {
                basePath.append(id);
            } else {
                basePath.append(baseDir);
            }
        }
        return fs;
    }

    private Configuration getHdfsConfiguration() throws IOException {
        Configuration config = new Configuration();
        Map properties = this.m_configManager.getHdfsProperties();
        String authentication = (String)properties.get("hadoop.security.authentication");
        config.setInt("io.file.buffer.size", 8192);
        config.setInt("dfs.replication", 3);
        for (Map.Entry property : properties.entrySet()) {
            config.set((String)property.getKey(), (String)property.getValue());
        }
        if ("kerberos".equals(authentication)) {
            System.setProperty("java.security.krb5.realm", this.getValue(properties, "java.security.krb5.realm", "DIANPING.COM"));
            System.setProperty("java.security.krb5.kdc", this.getValue(properties, "java.security.krb5.kdc", "192.168.7.80"));
            UserGroupInformation.setConfiguration((Configuration)config);
        }
        return config;
    }

    private String getValue(Map<String, String> properties, String name, String defaultValue) {
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void initialize() throws InitializationException {
        this.m_defaultBaseDir = this.m_configManager.getHdfsLocalBaseDir("hdfs");
        if (this.m_configManager.isHdfsOn()) {
            try {
                this.m_config = this.getHdfsConfiguration();
                SecurityUtil.login((Configuration)this.m_config, (String)"dfs.cat.keytab.file", (String)"dfs.cat.kerberos.principal");
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
        } else {
            this.m_config = new Configuration();
        }
    }
}

