/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.hadoop.hdfs.FileSystemManager;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import com.dianping.cat.message.storage.MessageBucket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.unidal.lookup.annotation.Inject;

public class HdfsMessageBucket
implements MessageBucket {
    public static final String ID = "hdfs";
    @Inject
    private FileSystemManager m_manager;
    @Inject
    private MessageCodec m_codec;
    private MessageBlockReader m_reader;
    private long m_lastAccessTime;

    public void close() throws IOException {
        this.m_reader.close();
    }

    public MessageTree findById(String messageId) throws IOException {
        int index = MessageId.parse((String)messageId).getIndex();
        try {
            byte[] data = this.m_reader.readMessage(index);
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(data.length);
            DefaultMessageTree tree = new DefaultMessageTree();
            buf.writeBytes(data);
            this.m_codec.decode(buf, (MessageTree)tree);
            this.m_lastAccessTime = System.currentTimeMillis();
            return tree;
        }
        catch (EOFException e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    public void initialize(String dataFile) throws IOException {
        this.m_reader = new MessageBlockReader(this.m_manager, dataFile);
    }

    public void setMessageCodec(MessageCodec codec) {
        this.m_codec = codec;
    }

    static class MessageBlockReader {
        private FSDataInputStream m_indexFile;
        private FSDataInputStream m_dataFile;

        public MessageBlockReader(FileSystemManager manager, String dataFile) throws IOException {
            StringBuilder sb = new StringBuilder();
            FileSystem fs = manager.getFileSystem("dump", sb);
            Path basePath = new Path(sb.toString());
            this.m_indexFile = fs.open(new Path(basePath, dataFile + ".idx"));
            this.m_dataFile = fs.open(new Path(basePath, dataFile));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FSDataInputStream fSDataInputStream = this.m_indexFile;
            synchronized (fSDataInputStream) {
                this.m_indexFile.close();
                this.m_dataFile.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readMessage(int index) throws IOException {
            byte[] buf;
            int blockOffset;
            int blockAddress;
            FSDataInputStream fSDataInputStream = this.m_indexFile;
            synchronized (fSDataInputStream) {
                this.m_indexFile.seek((long)index * 6L);
                blockAddress = this.m_indexFile.readInt();
                blockOffset = this.m_indexFile.readShort() & 0xFFFF;
            }
            fSDataInputStream = this.m_dataFile;
            synchronized (fSDataInputStream) {
                this.m_dataFile.seek((long)blockAddress);
                buf = new byte[this.m_dataFile.readInt()];
                this.m_dataFile.readFully(buf);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            DataInputStream in = new DataInputStream(new GZIPInputStream(bais));
            try {
                in.skip(blockOffset);
                int len = in.readInt();
                byte[] data = new byte[len];
                in.readFully(data);
                byte[] byArray = data;
                return byArray;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

