/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.clean;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.Transaction;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.cat.message.storage.clean.HdfsUploader;
import org.unidal.helper.Scanners;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class LogviewProcessor
implements Threads.Task,
Initializable {
    @Inject
    private HdfsUploader m_hdfsUploader;
    @Inject
    private ServerConfigManager m_configManager;
    private File m_baseDir;

    private void deleteLocalFile(String path) {
        File file = new File(this.m_baseDir, path);
        File parent = file.getParentFile();
        file.delete();
        parent.delete();
        parent.getParentFile().delete();
    }

    private void deleteOldMessages() {
        final HashSet paths = new HashSet();
        final Set<String> validPaths = this.findValidPath(this.m_configManager.getLogViewStroageTime());
        Scanners.forDir().scan(this.m_baseDir, (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (new File(base, path).isFile() && this.shouldDelete(path)) {
                    paths.add(path);
                }
                return Scanners.IMatcher.Direction.DOWN;
            }

            private boolean shouldDelete(String path) {
                for (String str : validPaths) {
                    if (!path.contains(str)) continue;
                    return false;
                }
                return true;
            }
        });
        if (paths.size() > 0) {
            this.processLogviewFiles(new ArrayList<String>(paths), false);
        }
    }

    public List<String> findOldBuckets() {
        final HashSet paths = new HashSet();
        Scanners.forDir().scan(this.m_baseDir, (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (new File(base, path).isFile() && LogviewProcessor.this.isOldBucketFile(path)) {
                    paths.add(path);
                }
                return Scanners.IMatcher.Direction.DOWN;
            }
        });
        return new ArrayList<String>(paths);
    }

    private Set<String> findValidPath(int storageDays) {
        HashSet<String> strs = new HashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long currentTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < storageDays; ++i) {
            Date date = new Date(currentTimeMillis - (long)i * 86400000L);
            strs.add(sdf.format(date));
        }
        return strs;
    }

    public String getName() {
        return "logview-processor";
    }

    public void initialize() throws InitializationException {
        this.m_baseDir = new File(this.m_configManager.getHdfsLocalBaseDir("dump"));
    }

    private boolean isOldBucketFile(String path) {
        long current = System.currentTimeMillis();
        long currentHour = current - current % 3600000L;
        long lastHour = currentHour - 3600000L;
        long nextHour = currentHour + 3600000L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd/HH");
        int currentPos = path.indexOf(sdf.format(new Date(currentHour)));
        int lastPos = path.indexOf(sdf.format(new Date(lastHour)));
        int nextPos = path.indexOf(sdf.format(new Date(nextHour)));
        return currentPos <= -1 && lastPos <= -1 && nextPos <= -1;
    }

    private void processLogviewFiles(List<String> paths, boolean upload) {
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        Transaction t = Cat.newTransaction((String)"System", (String)("Delete-" + ip));
        t.setStatus("0");
        t.addData("upload", (Object)String.valueOf(upload));
        for (String path : paths) {
            File file = new File(this.m_baseDir, path);
            String loginfo = "path:" + this.m_baseDir + "/" + path + ",file size: " + file.length();
            try {
                if (upload) {
                    this.uploadFileToHdfs(path);
                    Cat.getProducer().logEvent("Upload", "UploadAndDelete", "0", loginfo);
                    continue;
                }
                this.deleteLocalFile(path);
                Cat.getProducer().logEvent("Upload", "Delete", "0", loginfo);
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
        }
        t.complete();
    }

    public void run() {
        boolean active = true;
        while (active) {
            long start = System.currentTimeMillis();
            long current = start / 1000L / 60L;
            int min = (int)(current % 60L);
            Calendar nextStart = Calendar.getInstance();
            nextStart.set(12, 10);
            nextStart.add(10, 1);
            try {
                if (this.m_configManager.isHdfsOn()) {
                    if (min >= 9) {
                        List<String> paths = this.findOldBuckets();
                        this.processLogviewFiles(paths, true);
                    }
                } else {
                    this.deleteOldMessages();
                }
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
            }
            try {
                long end = System.currentTimeMillis();
                long sleepTime = nextStart.getTimeInMillis() - end;
                if (sleepTime <= 0L) continue;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }

    private void uploadFileToHdfs(String path) {
        File file = new File(this.m_baseDir, path);
        this.m_hdfsUploader.uploadLogviewFile(path, file);
    }
}

