/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.CodecHandler;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.cat.message.storage.Bucket;
import org.unidal.cat.message.storage.hdfs.HdfsBucket;
import org.unidal.cat.message.storage.hdfs.HdfsSystemManager;
import org.unidal.cat.message.storage.hdfs.MessageConsumerFinder;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class HdfsBucketManager
extends ContainerHolder
implements Initializable,
LogEnabled {
    protected Logger m_logger;
    @Inject
    private ServerConfigManager m_configManager;
    @Inject
    private HdfsSystemManager m_fileSystemManager;
    @Inject(value={"hdfs"})
    private MessageConsumerFinder m_consumerFinder;
    private Map<String, HdfsBucket> m_buckets = new LinkedHashMap<String, HdfsBucket>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, HdfsBucket> eldest) {
            return this.size() > 1000;
        }
    };

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void initialize() throws InitializationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTree loadMessage(MessageId id) {
        if (this.m_configManager.isHdfsOn()) {
            Transaction t = Cat.newTransaction((String)"Hdfs", (String)((Object)((Object)this)).getClass().getSimpleName());
            t.setStatus("0");
            try {
                Set<String> ips = this.m_consumerFinder.findConsumerIps(id.getDomain(), id.getHour());
                t.addData(ips.toString());
                MessageTree messageTree = this.readMessage(id, ips);
                return messageTree;
            }
            catch (RuntimeException e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
                throw e;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageTree readMessage(MessageId id, Set<String> ips) {
        Iterator<String> iterator = ips.iterator();
        while (iterator.hasNext()) {
            String ip = iterator.next();
            String domain = id.getDomain();
            int hour = id.getHour();
            String key = domain + '-' + ip + '-' + hour;
            try {
                ByteBuf data;
                HdfsBucket bucket = this.m_buckets.get(key);
                if (bucket == null) {
                    Map<String, HdfsBucket> map = this.m_buckets;
                    synchronized (map) {
                        bucket = this.m_buckets.get(key);
                        if (bucket == null) {
                            bucket = (HdfsBucket)this.lookup(Bucket.class, "hdfs");
                            bucket.initialize(domain, ip, hour);
                            this.m_buckets.put(key, bucket);
                            super.release((Object)bucket);
                        }
                    }
                }
                if (bucket == null || (data = bucket.get(id)) == null) continue;
                try {
                    MessageTree tree = CodecHandler.decode((ByteBuf)data);
                    if (!tree.getMessageId().equals(id.toString())) continue;
                    MessageTree messageTree = tree;
                    return messageTree;
                }
                finally {
                    CodecHandler.reset();
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return null;
    }
}

