/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.cat.message.storage.Index;
import org.unidal.cat.message.storage.hdfs.HdfsIndex;
import org.unidal.cat.message.storage.hdfs.HdfsSystemManager;
import org.unidal.cat.message.storage.hdfs.MessageConsumerFinder;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class HdfsIndexManager
extends ContainerHolder
implements Initializable,
LogEnabled {
    protected Logger m_logger;
    @Inject
    private ServerConfigManager m_configManager;
    @Inject
    private HdfsSystemManager m_fileSystemManager;
    @Inject(value={"hdfs"})
    private MessageConsumerFinder m_consumerFinder;
    private Map<String, HdfsIndex> m_buckets = new LinkedHashMap<String, HdfsIndex>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, HdfsIndex> eldest) {
            return this.size() > 1000;
        }
    };

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void initialize() throws InitializationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageId loadMessage(MessageId id) {
        if (this.m_configManager.isHdfsOn()) {
            Transaction t = Cat.newTransaction((String)"Hdfs", (String)((Object)((Object)this)).getClass().getSimpleName());
            t.setStatus("0");
            try {
                Set<String> ips = this.m_consumerFinder.findConsumerIps(id.getDomain(), id.getHour());
                t.addData(ips.toString());
                MessageId messageId = this.readMessage(id, ips);
                return messageId;
            }
            catch (RuntimeException e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
                throw e;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageId readMessage(MessageId id, Set<String> ips) {
        for (String ip : ips) {
            String domain = id.getDomain();
            int hour = id.getHour();
            String key = domain + '-' + ip + '-' + hour;
            try {
                MessageId to;
                HdfsIndex bucket = this.m_buckets.get(key);
                if (bucket == null) {
                    Map<String, HdfsIndex> map = this.m_buckets;
                    synchronized (map) {
                        bucket = this.m_buckets.get(key);
                        if (bucket == null) {
                            bucket = (HdfsIndex)this.lookup(Index.class, "hdfs");
                            bucket.initialize(domain, ip, hour);
                            this.m_buckets.put(key, bucket);
                            super.release((Object)bucket);
                        }
                    }
                }
                if (bucket == null || (to = bucket.find(id)) == null) continue;
                return to;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return null;
    }
}

