/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.internals;

import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.MessageId;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.cat.message.storage.Block;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class DefaultBlock
implements Block {
    private static final int MAX_SIZE = 262144;
    private String m_domain;
    private int m_hour;
    private ByteBuf m_data;
    private int m_offset;
    private Map<MessageId, Integer> m_offsets = new LinkedHashMap<MessageId, Integer>();
    private volatile OutputStream m_out;
    private volatile boolean m_isFlush;

    public DefaultBlock(MessageId id, int offset, byte[] data) {
        this.m_offsets.put(id, offset);
        this.m_data = data == null ? null : Unpooled.wrappedBuffer((byte[])data);
    }

    public DefaultBlock(String domain, int hour) {
        this.m_domain = domain;
        this.m_hour = hour;
        this.m_data = Unpooled.buffer((int)8192);
        this.m_out = this.createOutputSteam(this.m_data);
    }

    @Override
    public void clear() {
        this.m_data = null;
        this.m_offsets.clear();
    }

    private InputStream createInputSteam(ByteBuf buf) {
        ByteBufInputStream os = new ByteBufInputStream(buf);
        SnappyInputStream in = null;
        try {
            in = new SnappyInputStream((InputStream)os);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in;
    }

    private OutputStream createOutputSteam(ByteBuf buf) {
        ByteBufOutputStream os = new ByteBufOutputStream(buf);
        return new SnappyOutputStream((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf find(MessageId id) {
        Integer offset = this.m_offsets.get(id);
        if (offset != null) {
            this.m_isFlush = true;
            this.finish();
            ByteBuf copyData = Unpooled.copiedBuffer((ByteBuf)this.m_data);
            DataInputStream in = new DataInputStream(this.createInputSteam(copyData));
            try {
                in.skip(offset.intValue());
                int length = in.readInt();
                byte[] result = new byte[length];
                in.readFully(result);
                ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(4 + result.length);
                buf.writeInt(result.length);
                buf.writeBytes(result);
                ByteBuf byteBuf = buf;
                return byteBuf;
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finish() {
        block5: {
            try {
                if (this.m_out == null) break block5;
                OutputStream outputStream = this.m_out;
                synchronized (outputStream) {
                    this.m_out.flush();
                    this.m_out.close();
                    this.m_out = null;
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    @Override
    public ByteBuf getData() throws IOException {
        return this.m_data;
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public int getHour() {
        return this.m_hour;
    }

    @Override
    public Map<MessageId, Integer> getOffsets() {
        return this.m_offsets;
    }

    @Override
    public boolean isFull() {
        return this.m_offset >= 262144 || this.m_isFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pack(MessageId id, ByteBuf buf) throws IOException {
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            int len = buf.readableBytes();
            buf.readBytes(this.m_out, len);
            this.m_offsets.put(id, this.m_offset);
            this.m_offset += len;
        }
    }

    @Override
    public ByteBuf unpack(MessageId id) throws IOException {
        if (this.m_data == null) {
            return null;
        }
        InputStream snappyIn = this.createInputSteam(this.m_data);
        Integer offset = this.m_offsets.get(id);
        if (snappyIn == null || offset == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(snappyIn);
        in.skip(offset.intValue());
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] data = new byte[len];
        in.readFully(data);
        in.close();
        ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.buffer(4 + data.length);
        buf.writeInt(data.length);
        buf.writeBytes(data);
        return buf;
    }
}

