/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.internals;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.statistic.ServerStatisticManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.unidal.cat.message.storage.Block;
import org.unidal.cat.message.storage.BlockWriter;
import org.unidal.cat.message.storage.Bucket;
import org.unidal.cat.message.storage.BucketManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=BlockWriter.class, instantiationStrategy="per-lookup")
public class DefaultBlockWriter
implements BlockWriter {
    @Inject(value={"local"})
    private BucketManager m_bucketManager;
    @Inject
    private ServerStatisticManager m_statisticManager;
    private int m_index;
    private BlockingQueue<Block> m_queue;
    private long m_hour;
    private int m_count;
    private AtomicBoolean m_enabled;
    private CountDownLatch m_latch;

    public String getName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return this.getClass().getSimpleName() + " " + sdf.format(new Date(TimeUnit.HOURS.toMillis(this.m_hour))) + "-" + this.m_index;
    }

    @Override
    public void initialize(int hour, int index, BlockingQueue<Block> queue) {
        this.m_hour = hour;
        this.m_index = index;
        this.m_queue = queue;
        this.m_enabled = new AtomicBoolean(true);
        this.m_latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlock(String ip, Block block) {
        block12: {
            try {
                boolean monitor;
                Bucket bucket = this.m_bucketManager.getBucket(block.getDomain(), ip, block.getHour(), true);
                boolean bl = monitor = ++this.m_count % 1000 == 0;
                if (monitor) {
                    Transaction t = Cat.newTransaction((String)"Block", (String)block.getDomain());
                    try {
                        bucket.puts(block.getData(), block.getOffsets());
                    }
                    catch (Exception e) {
                        Cat.logError((String)ip, (Throwable)e);
                        t.setStatus("0");
                    }
                    t.setStatus("0");
                    t.complete();
                    break block12;
                }
                try {
                    bucket.puts(block.getData(), block.getOffsets());
                }
                catch (Exception e) {
                    Cat.logError((String)ip, (Throwable)e);
                }
            }
            catch (Exception e) {
                Cat.logError((String)ip, (Throwable)e);
            }
            catch (Error e) {
                Cat.logError((String)ip, (Throwable)e);
            }
            finally {
                block.clear();
            }
        }
    }

    public void run() {
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        try {
            while (this.m_enabled.get() || !this.m_queue.isEmpty()) {
                Block block = this.m_queue.poll(5L, TimeUnit.MILLISECONDS);
                if (block == null) continue;
                long time = System.currentTimeMillis();
                this.processBlock(ip, block);
                long duration = System.currentTimeMillis() - time;
                this.m_statisticManager.addBlockTime(duration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_latch.countDown();
    }

    public void shutdown() {
        Block block;
        this.m_enabled.set(false);
        try {
            this.m_latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while ((block = (Block)this.m_queue.poll()) != null) {
            this.processBlock(NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), block);
        }
    }
}

