/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.local;

import com.dianping.cat.Cat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.cat.message.storage.TokenMapping;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenMapping.class, value="local", instantiationStrategy="per-lookup")
public class LocalTokenMapping
implements TokenMapping {
    private static final int BLOCK_SIZE = 32768;
    private static final String MAGIC_CODE = "TokenMapping";
    @Inject(value={"local"})
    private PathBuilder m_bulider;
    private RandomAccessFile m_file;
    private File m_path;
    private List<String> m_tokens = new ArrayList<String>(1024);
    private Map<String, Integer> m_map = new HashMap<String, Integer>(1024);
    private int m_block;
    private ByteBuf m_data;
    private long m_lastAccessTime;
    private boolean m_dirty;

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        try {
            this.m_file.close();
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        this.m_tokens.clear();
        this.m_map.clear();
    }

    @Override
    public String find(int index) throws IOException {
        int len = this.m_tokens.size();
        if (index < len) {
            this.m_lastAccessTime = System.currentTimeMillis();
            return this.m_tokens.get(index);
        }
        return null;
    }

    private void flush() throws IOException {
        if (this.m_dirty) {
            this.m_file.seek(1L * (long)this.m_block * 32768L);
            this.m_file.write(this.m_data.array());
            this.m_dirty = false;
        }
    }

    @Override
    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    private void loadFrom(ByteBuf buf, int length) throws IOException {
        short len;
        int index = this.m_map.size();
        buf.writerIndex(length);
        while (buf.isReadable(2) && (len = buf.readShort()) > 0) {
            byte[] data = new byte[len];
            buf.readBytes(data, 0, (int)len);
            String token = new String(data, 0, (int)len, "utf-8");
            this.m_tokens.add(token);
            this.m_map.put(token, index++);
        }
        buf.writerIndex(buf.readerIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int map(String token) throws IOException {
        Integer index = this.m_map.get(token);
        if (index == null) {
            Map<String, Integer> map = this.m_map;
            synchronized (map) {
                index = this.m_map.get(token);
                if (index == null) {
                    byte[] ba = token.getBytes("utf-8");
                    int len = ba.length;
                    if (!this.m_data.isWritable(2 + len)) {
                        this.flush();
                        this.m_data.clear();
                        this.m_data.setZero(0, this.m_data.capacity());
                        ++this.m_block;
                    }
                    index = this.m_tokens.size();
                    this.m_data.writeShort(len);
                    this.m_data.writeBytes(ba);
                    this.m_tokens.add(token);
                    this.m_map.put(token, index);
                    this.m_dirty = true;
                    this.m_lastAccessTime = System.currentTimeMillis();
                }
            }
        }
        return index;
    }

    @Override
    public void open(int hour, String ip) throws IOException {
        this.m_path = new File(this.m_bulider.getPath(null, new Date((long)hour * 3600000L), ip, FileType.TOKEN));
        this.m_path.getParentFile().mkdirs();
        this.m_file = new RandomAccessFile(this.m_path, "rwd");
        this.m_data = Unpooled.buffer((int)32768);
        this.m_block = 0;
        while (true) {
            this.m_file.seek(1L * (long)this.m_block * 32768L);
            int size = this.m_file.read(this.m_data.array());
            if (size < 0) break;
            this.loadFrom(this.m_data, size);
            this.m_data.clear();
            this.m_data.setZero(0, this.m_data.capacity());
            ++this.m_block;
        }
        if (this.m_map.isEmpty()) {
            this.m_data.writeShort(MAGIC_CODE.length());
            this.m_data.writeBytes(MAGIC_CODE.getBytes());
            this.m_tokens.add(MAGIC_CODE);
            this.m_map.put(MAGIC_CODE, 0);
        }
    }
}

