/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFileSystem;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.tuple.Pair;

public class HarConnectionPool
implements Initializable {
    private ServerConfigManager m_serverConfigManager;
    private MessageFormat m_format = new MessageFormat("{0}/{1}/{2,date,yyyyMMdd}/{2,date,HH}.har");
    private Map<String, Pair<HarFileSystem, Long>> m_hars = new ConcurrentHashMap<String, Pair<HarFileSystem, Long>>();

    public HarConnectionPool(ServerConfigManager manager) {
        this.m_serverConfigManager = manager;
    }

    private void closeIdleHarfs() throws IOException {
        long now = System.currentTimeMillis();
        HashSet<String> closed = new HashSet<String>();
        for (Map.Entry<String, Pair<HarFileSystem, Long>> entry : this.m_hars.entrySet()) {
            Pair<HarFileSystem, Long> pair = entry.getValue();
            if (now - (Long)pair.getValue() < 3600000L) continue;
            try {
                closed.add(entry.getKey());
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        for (String close : closed) {
            this.m_hars.remove(close);
            Cat.logEvent((String)"HarConnClose", (String)close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarFileSystem getHarfsConnection(String id, Date date, FileSystem fs) throws IOException {
        String serverUri = this.m_serverConfigManager.getHarfsServerUri(id);
        String baseUri = this.m_serverConfigManager.getHarfsBaseDir(id);
        String harUri = this.m_format.format(new Object[]{serverUri, baseUri, date});
        Pair har = this.m_hars.get(harUri);
        long current = System.currentTimeMillis();
        if (har == null) {
            HarConnectionPool harConnectionPool = this;
            synchronized (harConnectionPool) {
                if (har == null) {
                    URI uri = URI.create(harUri);
                    HarFileSystem harfs = new HarFileSystem(fs);
                    try {
                        harfs.initialize(uri, harfs.getConf());
                        har = new Pair((Object)harfs, (Object)current);
                        this.m_hars.put(harUri, (Pair<HarFileSystem, Long>)har);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if (har != null) {
            har.setValue((Object)current);
            return (HarFileSystem)har.getKey();
        }
        return null;
    }

    public void initialize() throws InitializationException {
        Threads.forGroup((String)"cat").start((Runnable)((Object)new IdleChecker()));
    }

    class IdleChecker
    implements Threads.Task {
        IdleChecker() {
        }

        public String getName() {
            return "HarConnectionPool-IdleChecker";
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    try {
                        HarConnectionPool.this.closeIdleHarfs();
                    }
                    catch (IOException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void shutdown() {
        }
    }
}

