/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.hadoop.hdfs.FileSystemManager;
import com.dianping.cat.message.PathBuilder;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucket;
import com.dianping.cat.message.storage.MessageBucketManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

public class HdfsMessageBucketManager
extends ContainerHolder
implements MessageBucketManager,
Initializable {
    public static final String ID = "hdfs";
    public static final String HDFS_BUCKET = "HdfsMessageBucket";
    public static final String HARFS_BUCKET = "HarfsMessageBucket";
    @Inject
    private FileSystemManager m_manager;
    @Inject
    private PathBuilder m_pathBuilder;
    @Inject
    private ServerConfigManager m_serverConfigManager;
    private Map<String, MessageBucket> m_buckets = new ConcurrentHashMap<String, MessageBucket>();

    public void archive(long startTime) {
        throw new RuntimeException("not support in hdfs message bucket manager");
    }

    private void closeIdleBuckets() throws IOException {
        MessageBucket bucket;
        long now = System.currentTimeMillis();
        long hour = 3600000L;
        HashSet<String> closed = new HashSet<String>();
        for (Map.Entry<String, MessageBucket> entry : this.m_buckets.entrySet()) {
            bucket = entry.getValue();
            if (now - bucket.getLastAccessTime() < hour) continue;
            try {
                bucket.close();
                closed.add(entry.getKey());
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        for (String close : closed) {
            bucket = this.m_buckets.remove(close);
            this.release(bucket);
        }
    }

    private List<String> filterFiles(FileSystem fs, MessageId id, String base, final String path) {
        final ArrayList<String> paths = new ArrayList<String>();
        try {
            Path basePath = new Path(base + path);
            final String key = id.getDomain() + '-' + id.getIpAddress();
            if (fs != null) {
                fs.listStatus(basePath, new PathFilter(){

                    public boolean accept(Path p) {
                        String name = p.getName();
                        if (name.contains(key) && !name.endsWith(".idx")) {
                            paths.add(path + name);
                        }
                        return false;
                    }
                });
            }
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        return paths;
    }

    public void initialize() throws InitializationException {
        if (this.m_serverConfigManager.isHdfsOn()) {
            Threads.forGroup((String)"cat").start((Runnable)((Object)new IdleChecker()));
        }
    }

    private Pair<List<String>, String> loadFileFromHar(MessageId id, Date date) throws IOException {
        HarFileSystem fs = this.m_manager.getHarFileSystem("dump", date);
        List<String> paths = this.filterFiles((FileSystem)fs, id, ".", "");
        return new Pair(paths, (Object)HARFS_BUCKET);
    }

    private Pair<List<String>, String> loadFileFromHdfs(MessageId id, Date date) throws IOException {
        StringBuilder sb = new StringBuilder();
        String p = this.m_pathBuilder.getLogviewPath(date, "");
        FileSystem fs = this.m_manager.getFileSystem("dump", sb);
        List<String> paths = this.filterFiles(fs, id, sb.toString(), p);
        return new Pair(paths, (Object)HDFS_BUCKET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTree loadMessage(String messageId) {
        if (!this.m_serverConfigManager.isHdfsOn()) {
            return null;
        }
        Transaction t = Cat.newTransaction((String)"BucketService", (String)((Object)((Object)this)).getClass().getSimpleName());
        t.setStatus("0");
        try {
            MessageId id = MessageId.parse((String)messageId);
            Date date = new Date(id.getTimestamp());
            Pair<List<String>, String> pair = null;
            if (this.m_serverConfigManager.isHarMode()) {
                pair = this.loadFileFromHar(id, date);
            }
            if (pair == null || ((List)pair.getKey()).isEmpty()) {
                pair = this.loadFileFromHdfs(id, date);
            }
            ((DefaultTransaction)t).setName((String)pair.getValue());
            t.addData(((List)pair.getKey()).toString());
            MessageTree messageTree = this.readMessage(messageId, date, t, (List)pair.getKey());
            return messageTree;
        }
        catch (RuntimeException e) {
            t.setStatus((Throwable)e);
            Cat.logError((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            Cat.logError((Throwable)e);
        }
        finally {
            t.complete();
        }
        return null;
    }

    private MessageTree readMessage(String messageId, Date date, Transaction t, List<String> paths) {
        for (String dataFile : paths) {
            try {
                MessageTree tree;
                String type = t.getName();
                StringBuilder sb = new StringBuilder();
                sb.append(type).append("-").append(date.toString()).append("-").append(dataFile);
                String bKey = sb.toString();
                Cat.logEvent((String)type, (String)bKey);
                MessageBucket bucket = this.m_buckets.get(bKey);
                if (bucket == null) {
                    bucket = (MessageBucket)this.lookup(MessageBucket.class, type);
                    bucket.initialize(dataFile, date);
                    this.m_buckets.put(bKey, bucket);
                }
                if ((tree = bucket.findById(messageId)) == null || !tree.getMessageId().equals(messageId)) continue;
                t.addData("path", (Object)dataFile);
                return tree;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
        }
        return null;
    }

    public void storeMessage(MessageTree tree, MessageId id) {
        throw new UnsupportedOperationException("Not supported by HDFS!");
    }

    class IdleChecker
    implements Threads.Task {
        IdleChecker() {
        }

        public String getName() {
            return "HdfsMessageBucketManager-IdleChecker";
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    try {
                        HdfsMessageBucketManager.this.closeIdleBuckets();
                    }
                    catch (IOException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void shutdown() {
        }
    }
}

