/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs;

import com.dianping.cat.Cat;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.xerial.snappy.SnappyInputStream;

public class MessageBlockReader {
    private FSDataInputStream m_indexFile;
    private FSDataInputStream m_dataFile;

    public MessageBlockReader(FileSystem fs, Path basePath, String dataFile) throws IOException {
        this.m_indexFile = fs.open(new Path(basePath, dataFile + ".idx"));
        this.m_dataFile = fs.open(new Path(basePath, dataFile));
    }

    public MessageBlockReader(FileSystem fs, String dataFile) throws IOException {
        this.m_indexFile = fs.open(new Path(dataFile + ".idx"));
        this.m_dataFile = fs.open(new Path(dataFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FSDataInputStream fSDataInputStream = this.m_indexFile;
        synchronized (fSDataInputStream) {
            this.m_indexFile.close();
            this.m_dataFile.close();
        }
    }

    private DataInputStream createDataInputStream(byte[] buf) {
        DataInputStream in = null;
        try {
            in = new DataInputStream((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(buf)));
        }
        catch (IOException e) {
            try {
                in = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(buf)));
            }
            catch (IOException ioe) {
                Cat.logError((Throwable)ioe);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readMessage(int index) throws IOException {
        byte[] buf;
        int blockOffset;
        int blockAddress;
        FSDataInputStream fSDataInputStream = this.m_indexFile;
        synchronized (fSDataInputStream) {
            this.m_indexFile.seek((long)index * 6L);
            blockAddress = this.m_indexFile.readInt();
            blockOffset = this.m_indexFile.readShort() & 0xFFFF;
        }
        fSDataInputStream = this.m_dataFile;
        synchronized (fSDataInputStream) {
            this.m_dataFile.seek((long)blockAddress);
            buf = new byte[this.m_dataFile.readInt()];
            this.m_dataFile.readFully(buf);
        }
        DataInputStream in = this.createDataInputStream(buf);
        if (in != null) {
            try {
                in.skip(blockOffset);
                int len = in.readInt();
                byte[] data = new byte[len];
                in.readFully(data);
                byte[] byArray = data;
                return byArray;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

