/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs.bucket;

import com.dianping.cat.hadoop.hdfs.FileSystemManager;
import com.dianping.cat.hadoop.hdfs.MessageBlockReader;
import com.dianping.cat.message.CodecHandler;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.EOFException;
import java.io.IOException;
import java.util.Date;
import org.unidal.lookup.annotation.Inject;

public abstract class AbstractHdfsMessageBucket
implements MessageBucket {
    @Inject
    protected FileSystemManager m_manager;
    protected MessageBlockReader m_reader;
    protected long m_lastAccessTime;
    protected String m_id = "dump";

    public void close() throws IOException {
        this.m_reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTree findById(String messageId) throws IOException {
        int index = MessageId.parse((String)messageId).getIndex();
        try {
            byte[] data = this.m_reader.readMessage(index);
            if (data != null) {
                ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(data.length);
                buf.writeBytes(data);
                MessageTree tree = CodecHandler.decode((ByteBuf)buf);
                this.m_lastAccessTime = System.currentTimeMillis();
                MessageTree messageTree = tree;
                return messageTree;
            }
            MessageTree messageTree = null;
            return messageTree;
        }
        catch (EOFException e) {
            MessageTree messageTree = null;
            return messageTree;
        }
        finally {
            CodecHandler.reset();
        }
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    public abstract void initialize(String var1) throws IOException;

    public abstract void initialize(String var1, Date var2) throws IOException;
}

