/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.hadoop.hdfs.bucket;

import com.dianping.cat.hadoop.hdfs.MessageBlockReader;
import com.dianping.cat.hadoop.hdfs.bucket.AbstractHdfsMessageBucket;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.Path;

public class HarfsMessageBucket
extends AbstractHdfsMessageBucket {
    public static final String ID = "HarfsMessageBucket";

    @Override
    public void initialize(String dataFile) throws IOException {
        this.initialize(dataFile, new Date());
    }

    @Override
    public void initialize(String dataFile, Date date) throws IOException {
        HarFileSystem fs = this.m_manager.getHarFileSystem(this.m_id, date);
        int index = dataFile.indexOf("/");
        if (index > 0) {
            String parent = dataFile.substring(0, index);
            dataFile = dataFile.substring(index + 1);
            Path basePath = new Path(parent);
            this.m_reader = new MessageBlockReader((FileSystem)fs, basePath, dataFile);
        } else {
            this.m_reader = new MessageBlockReader((FileSystem)fs, dataFile);
        }
    }
}

