/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.hdfs;

import com.dianping.cat.Cat;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.unidal.cat.message.storage.hdfs.HdfsSystemManager;
import org.unidal.cat.message.storage.hdfs.MessageConsumerFinder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=MessageConsumerFinder.class, value="hdfs")
public class HdfsMessageConsumerFinder
implements MessageConsumerFinder {
    @Inject
    private HdfsSystemManager m_fileSystemManager;
    private Map<String, Set<String>> m_caches = new HashMap<String, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> findConsumerIps(String domain, int hour) {
        String key = domain + '-' + hour;
        Set<String> ips = this.m_caches.get(key);
        if (ips == null) {
            Map<String, Set<String>> map = this.m_caches;
            synchronized (map) {
                ips = this.m_caches.get(key);
                if (ips == null) {
                    ips = this.findfromHdfs(domain, hour);
                    this.m_caches.put(key, ips);
                }
            }
        }
        return ips;
    }

    private Set<String> findfromHdfs(final String domain, int hour) {
        FileSystem fs;
        Date start = new Date((long)hour * 3600000L);
        MessageFormat format = new MessageFormat("/{0,date,yyyyMMdd}/{0,date,HH}");
        String parent = this.m_fileSystemManager.getBaseDir() + format.format(new Object[]{start});
        try {
            fs = this.m_fileSystemManager.getFileSystem();
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
            return null;
        }
        final HashSet<String> result = new HashSet<String>();
        try {
            Path basePath = new Path(parent);
            if (fs != null) {
                fs.listStatus(basePath, new PathFilter(){

                    public boolean accept(Path p) {
                        String name = p.getName();
                        if (name.contains(domain) && name.endsWith(".dat")) {
                            int start = name.lastIndexOf(45);
                            int end = name.length() - 4;
                            result.add(name.substring(start + 1, end));
                        }
                        return false;
                    }
                });
            }
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        return result;
    }
}

