/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.hdfs;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class HdfsSystemManager
implements Initializable {
    public static final String DUMP = "dump";
    @Inject
    private ServerConfigManager m_configManager;
    private FileSystem m_fileSystem;
    private Configuration m_config;

    public String getBaseDir() {
        return this.m_configManager.getHdfsBaseDir(DUMP);
    }

    public Configuration getConfig() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem() throws IOException {
        String serverUri = this.m_configManager.getHdfsServerUri(DUMP);
        if (this.m_fileSystem == null) {
            HdfsSystemManager hdfsSystemManager = this;
            synchronized (hdfsSystemManager) {
                if (this.m_fileSystem == null) {
                    URI uri = URI.create(serverUri);
                    this.m_fileSystem = FileSystem.get((URI)uri, (Configuration)this.m_config);
                }
            }
        }
        return this.m_fileSystem;
    }

    private Configuration getHdfsConfiguration() throws IOException {
        Configuration config = new Configuration();
        Map properties = this.m_configManager.getHdfsProperties();
        String authentication = (String)properties.get("hadoop.security.authentication");
        config.setInt("io.file.buffer.size", 8192);
        config.setInt("dfs.replication", 1);
        for (Map.Entry property : properties.entrySet()) {
            config.set((String)property.getKey(), (String)property.getValue());
        }
        if ("kerberos".equals(authentication)) {
            System.setProperty("java.security.krb5.realm", this.getValue(properties, "java.security.krb5.realm", "DIANPING.COM"));
            System.setProperty("java.security.krb5.kdc", this.getValue(properties, "java.security.krb5.kdc", "192.168.7.80"));
            UserGroupInformation.setConfiguration((Configuration)config);
        }
        return config;
    }

    private String getValue(Map<String, String> properties, String name, String defaultValue) {
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void initialize() throws InitializationException {
        if (this.m_configManager.isHdfsOn()) {
            try {
                this.m_config = this.getHdfsConfiguration();
                SecurityUtil.login((Configuration)this.m_config, (String)"dfs.cat.keytab.file", (String)"dfs.cat.kerberos.principal");
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
        } else {
            this.m_config = new Configuration();
        }
    }
}

