/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.hdfs;

import com.dianping.cat.Cat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.cat.message.storage.TokenMapping;
import org.unidal.cat.message.storage.hdfs.HdfsSystemManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TokenMapping.class, value="hdfs", instantiationStrategy="per-lookup")
public class HdfsTokenMapping
implements TokenMapping {
    private static final int BLOCK_SIZE = 32768;
    private static final String MAGIC_CODE = "TokenMapping";
    @Inject
    protected HdfsSystemManager m_manager;
    @Inject(value={"hdfs"})
    private PathBuilder m_bulider;
    private FSDataInputStream m_file;
    private List<String> m_tokens = new ArrayList<String>(1024);
    private Map<String, Integer> m_map = new HashMap<String, Integer>(1024);
    private int m_block;
    private ByteBuf m_data;
    private long m_lastAccessTime;

    @Override
    public void close() {
        try {
            this.m_file.close();
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        this.m_tokens.clear();
        this.m_map.clear();
    }

    @Override
    public String find(int index) throws IOException {
        int len = this.m_tokens.size();
        if (index < len) {
            this.m_lastAccessTime = System.currentTimeMillis();
            return this.m_tokens.get(index);
        }
        return null;
    }

    @Override
    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    private void loadFrom(ByteBuf buf, int length) throws IOException {
        short len;
        int index = this.m_map.size();
        buf.writerIndex(length);
        while (buf.isReadable(2) && (len = buf.readShort()) > 0) {
            byte[] data = new byte[len];
            buf.readBytes(data, 0, (int)len);
            String token = new String(data, 0, (int)len, "utf-8");
            this.m_tokens.add(token);
            this.m_map.put(token, index++);
        }
        buf.writerIndex(buf.readerIndex());
    }

    @Override
    public int map(String token) throws IOException {
        throw new RuntimeException("unsupport operation");
    }

    @Override
    public void open(int hour, String ip) throws IOException {
        String path = this.m_bulider.getPath(null, new Date((long)hour * 3600000L), ip, FileType.TOKEN);
        FileSystem fs = this.m_manager.getFileSystem();
        this.m_file = fs.open(new Path(path));
        this.m_data = Unpooled.buffer((int)32768);
        this.m_block = 0;
        while (true) {
            this.m_file.seek(1L * (long)this.m_block * 32768L);
            int size = this.m_file.read(this.m_data.array());
            if (size < 0) break;
            this.loadFrom(this.m_data, size);
            this.m_data.clear();
            this.m_data.setZero(0, this.m_data.capacity());
            ++this.m_block;
        }
        if (this.m_map.isEmpty()) {
            this.m_data.writeShort(MAGIC_CODE.length());
            this.m_data.writeBytes(MAGIC_CODE.getBytes());
            this.m_tokens.add(MAGIC_CODE);
            this.m_map.put(MAGIC_CODE, 0);
        }
    }
}

