/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.internals;

import com.dianping.cat.Cat;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.cat.message.storage.internals.ByteBufCache;
import org.unidal.lookup.annotation.Named;

@Named(type=ByteBufCache.class)
public class DefaultByteBufCache
implements ByteBufCache,
Initializable,
LogEnabled {
    private BlockingQueue<ByteBuffer> m_bufs = new ArrayBlockingQueue<ByteBuffer>(8000);
    private Logger m_logger;
    private AtomicInteger m_count = new AtomicInteger();

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer buf = (ByteBuffer)this.m_bufs.poll();
        if (buf == null) {
            buf = ByteBuffer.allocate(32768);
        }
        return buf;
    }

    public void initialize() throws InitializationException {
    }

    @Override
    public void put(ByteBuffer buf) {
        byte[] array = buf.array();
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
        buf.clear();
        boolean result = this.m_bufs.offer(buf);
        if (!result) {
            try {
                ReferenceCountUtil.release((Object)buf);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
            if (this.m_count.incrementAndGet() % 100 == 0) {
                this.m_logger.info("error when put back buf");
            }
        }
    }
}

