/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.internals;

import com.dianping.cat.message.internal.MessageId;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.cat.message.storage.MessageFinder;
import org.unidal.cat.message.storage.MessageFinderManager;
import org.unidal.lookup.annotation.Named;

@Named(type=MessageFinderManager.class)
public class DefaultMessageFinderManager
implements MessageFinderManager {
    private Map<Integer, List<MessageFinder>> m_map = new HashMap<Integer, List<MessageFinder>>();

    @Override
    public synchronized void close(int hour) {
        this.m_map.remove(hour);
    }

    @Override
    public ByteBuf find(MessageId id) {
        int hour = id.getHour();
        List<MessageFinder> finders = this.m_map.get(hour);
        if (finders != null) {
            for (MessageFinder finder : finders) {
                ByteBuf buf = finder.find(id);
                if (buf == null) continue;
                return buf;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(int hour, MessageFinder finder) {
        List<MessageFinder> finders = this.m_map.get(hour);
        if (finders == null) {
            Map<Integer, List<MessageFinder>> map = this.m_map;
            synchronized (map) {
                finders = this.m_map.get(hour);
                if (finders == null) {
                    finders = new ArrayList<MessageFinder>();
                    this.m_map.put(hour, finders);
                }
            }
        }
        finders.add(finder);
    }
}

