/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.local;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.internal.MessageId;
import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.unidal.cat.message.storage.Bucket;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.cat.message.storage.internals.ByteBufCache;
import org.unidal.cat.message.storage.internals.DefaultBlock;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=Bucket.class, value="local", instantiationStrategy="per-lookup")
public class LocalBucket
implements Bucket {
    @Inject(value={"local"})
    private PathBuilder m_builder;
    @Inject
    private ByteBufCache m_bufCache;
    @Inject
    private ServerConfigManager m_config;
    private DataHelper m_data = new DataHelper();
    private IndexHelper m_index = new IndexHelper();
    private boolean m_nioEnabled = true;
    private boolean m_writeMode;
    private AtomicInteger m_count = new AtomicInteger();

    @Override
    public synchronized void close() {
        if (this.m_index.isOpen()) {
            this.m_data.close();
            if (this.m_writeMode) {
                this.m_index.flushAndClose();
            } else {
                this.m_index.close();
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.m_data.m_out.flush();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    @Override
    public ByteBuf get(MessageId id) throws IOException {
        long address = this.m_index.read(id);
        if (address <= 0L) {
            return null;
        }
        int segmentOffset = (int)(address & 0xFFFFFFL);
        long dataOffset = address >> 24;
        byte[] data = this.m_data.read(dataOffset);
        if (data != null) {
            DefaultBlock block = new DefaultBlock(id, segmentOffset, data);
            return block.unpack(id);
        }
        return null;
    }

    @Override
    public boolean initialize(String domain, String ip, int hour, boolean writeMode) throws IOException {
        this.m_nioEnabled = this.m_config.getStroargeNioEnable();
        long timestamp = (long)(hour * 3600) * 1000L;
        Date startTime = new Date(timestamp);
        File indexPath = new File(this.m_builder.getPath(domain, startTime, ip, FileType.INDEX));
        File dataPath = new File(this.m_builder.getPath(domain, startTime, ip, FileType.DATA));
        this.m_writeMode = writeMode;
        this.m_index.init(indexPath);
        this.m_data.init(dataPath);
        return true;
    }

    @Override
    public synchronized void puts(ByteBuf data, Map<MessageId, Integer> mappings) throws IOException {
        long dataOffset = this.m_data.getDataOffset();
        this.m_data.write(data);
        for (Map.Entry<MessageId, Integer> e : mappings.entrySet()) {
            MessageId id = e.getKey();
            int offset = e.getValue();
            this.m_index.write(id, dataOffset, offset);
        }
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.m_data.getPath());
    }

    private class IndexHelper {
        private RandomAccessFile m_file;
        private File m_path;
        private FileChannel m_indexChannel;
        private Header m_header = new Header();
        private Map<String, SegmentCache> m_caches = new LinkedHashMap<String, SegmentCache>();

        private IndexHelper() {
        }

        private void close() {
            try {
                this.m_indexChannel.close();
                this.m_file.close();
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            this.m_file = null;
            this.m_caches.clear();
        }

        private void flushAndClose() {
            try {
                this.m_header.m_segment.flushAndClose();
                for (SegmentCache cache : this.m_caches.values()) {
                    cache.flushAndClose();
                }
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            if (LocalBucket.this.m_nioEnabled) {
                try {
                    this.m_indexChannel.force(false);
                    this.m_indexChannel.close();
                }
                catch (IOException e) {
                    Cat.logError((Throwable)e);
                }
            }
            try {
                this.m_file.close();
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            this.m_file = null;
            this.m_caches.clear();
        }

        private Segment getSegment(String ip, long id) throws IOException {
            SegmentCache cache = this.m_caches.get(ip);
            if (cache == null) {
                cache = new SegmentCache();
                this.m_caches.put(ip, cache);
            }
            return cache.findOrCreateNextSegment(id);
        }

        private void init(File indexPath) throws IOException {
            this.m_path = indexPath;
            this.m_path.getParentFile().mkdirs();
            this.m_file = new RandomAccessFile(this.m_path, "rw");
            this.m_indexChannel = this.m_file.getChannel();
            long size = this.m_file.length();
            int totalHeaders = (int)Math.ceil((double)size * 1.0 / 1.34217728E8);
            if (totalHeaders == 0) {
                totalHeaders = 1;
            }
            for (int i = 0; i < totalHeaders; ++i) {
                this.m_header.load(i);
            }
        }

        private boolean isOpen() {
            return this.m_file != null;
        }

        private long read(MessageId id) throws IOException {
            int index = id.getIndex();
            long position = this.m_header.getOffset(id.getIpAddressValue(), index, false);
            int segmentId = (int)(position / 32768L);
            int offset = (int)(position % 32768L);
            Segment segment = this.getSegment(id.getIpAddressInHex(), segmentId);
            if (segment != null) {
                try {
                    return segment.readLong(offset);
                }
                catch (EOFException eOFException) {
                }
            } else if (position > 0L) {
                this.m_file.seek(position);
                return this.m_file.readLong();
            }
            return -1L;
        }

        private void write(MessageId id, long blockAddress, int blockOffset) throws IOException {
            long position = this.m_header.getOffset(id.getIpAddressValue(), id.getIndex(), true);
            long address = position / 32768L;
            int offset = (int)(position % 32768L);
            Segment segment = this.getSegment(id.getIpAddressInHex(), address);
            long value = (blockAddress << 24) + (long)blockOffset;
            if (segment != null) {
                segment.writeLong(offset, value);
            } else {
                if (LocalBucket.this.m_count.incrementAndGet() % 1000 == 0) {
                    Cat.logEvent((String)"AbnormalBlock", (String)id.getDomain());
                }
                if (LocalBucket.this.m_nioEnabled) {
                    this.m_indexChannel.position(position);
                    ByteBuffer buf = ByteBuffer.allocate(8);
                    buf.putLong(value);
                    buf.flip();
                    this.m_indexChannel.write(buf);
                } else {
                    this.m_file.seek(position);
                    this.m_file.writeLong(value);
                }
            }
        }

        private class SegmentCache {
            private static final int CACHE_SIZE = 2;
            private long m_maxSegmentId;
            private Map<Long, Segment> m_latestSegments = new LinkedHashMap<Long, Segment>();

            private SegmentCache() {
            }

            private synchronized void flushAndClose() throws IOException {
                for (Segment segment : this.m_latestSegments.values()) {
                    segment.flushAndClose();
                }
                this.m_latestSegments.clear();
            }

            private Segment findOrCreateNextSegment(long segmentId) throws IOException {
                Segment segment = this.m_latestSegments.get(segmentId);
                if (segment == null && segmentId > this.m_maxSegmentId) {
                    if (this.m_latestSegments.size() >= 2) {
                        this.removeOldSegment();
                    }
                    segment = new Segment(IndexHelper.this.m_indexChannel, segmentId * 32768L);
                    this.m_latestSegments.put(segmentId, segment);
                    this.m_maxSegmentId = segmentId;
                }
                return segment;
            }

            private void removeOldSegment() throws IOException {
                Map.Entry<Long, Segment> first = this.m_latestSegments.entrySet().iterator().next();
                Segment segment = this.m_latestSegments.remove(first.getKey());
                segment.flushAndClose();
            }
        }

        private class Segment {
            private FileChannel m_segmentChannel;
            private long m_address;
            private ByteBuffer m_buf;

            private Segment(FileChannel channel, long address) throws IOException {
                this.m_segmentChannel = channel;
                this.m_address = address;
                this.m_buf = LocalBucket.this.m_bufCache.get();
                this.m_buf.mark();
                this.m_segmentChannel.read(this.m_buf, address);
                this.m_buf.reset();
            }

            private synchronized void flushAndClose() throws IOException {
                if (this.m_buf != null) {
                    int pos = this.m_buf.position();
                    this.m_buf.position(0);
                    this.m_segmentChannel.write(this.m_buf, this.m_address);
                    this.m_buf.position(pos);
                    LocalBucket.this.m_bufCache.put(this.m_buf);
                    this.m_buf = null;
                } else {
                    Cat.logEvent((String)"CloseBucket", (String)("Duplicate:" + IndexHelper.this.m_path.getAbsolutePath()));
                }
            }

            private int readInt() throws IOException {
                return this.m_buf.getInt();
            }

            private long readLong() throws IOException {
                return this.m_buf.getLong();
            }

            private long readLong(int offset) throws IOException {
                return this.m_buf.getLong(offset);
            }

            public String toString() {
                return String.format("%s[address=%s]", this.getClass().getSimpleName(), this.m_address);
            }

            private void writeLong(int offset, long value) throws IOException {
                this.m_buf.putLong(offset, value);
            }
        }

        private class Header {
            private Map<Integer, Map<Integer, Integer>> m_table = new LinkedHashMap<Integer, Map<Integer, Integer>>();
            private int m_nextSegment;
            private Segment m_segment;
            private int m_offset;

            private Header() {
            }

            private Integer findSegment(int ip, int index, boolean createIfNotExists) throws IOException {
                Integer segmentId;
                Map<Integer, Integer> map = this.m_table.get(ip);
                if (map == null && createIfNotExists) {
                    map = new HashMap<Integer, Integer>();
                    this.m_table.put(ip, map);
                }
                Integer n = segmentId = map == null ? null : map.get(index);
                if (segmentId == null && createIfNotExists) {
                    long value = ((long)ip << 32) + (long)index;
                    segmentId = this.m_nextSegment;
                    map.put(index, segmentId);
                    this.m_segment.writeLong(this.m_offset, value);
                    this.m_offset += 8;
                    ++this.m_nextSegment;
                    if (this.m_nextSegment % 4096 == 0) {
                        this.m_segment.flushAndClose();
                        this.m_segment = new Segment(IndexHelper.this.m_indexChannel, (long)this.m_nextSegment * 32768L);
                        ++this.m_nextSegment;
                        this.m_segment.writeLong(0, -1L);
                        this.m_offset = 8;
                    }
                }
                return segmentId;
            }

            private long getOffset(int ip, int seq, boolean createIfNotExists) throws IOException {
                int segmentIndex = seq / 4096;
                int segmentOffset = seq % 4096 * 8;
                Integer segmentId = this.findSegment(ip, segmentIndex, createIfNotExists);
                if (segmentId != null) {
                    return (long)segmentId.intValue() * 32768L + (long)segmentOffset;
                }
                return -1L;
            }

            private void load(int headBlockIndex) throws IOException {
                Segment segment = new Segment(IndexHelper.this.m_indexChannel, (long)headBlockIndex * 4096L * 32768L);
                long magicCode = segment.readLong();
                if (magicCode == 0L) {
                    segment.writeLong(0, -1L);
                } else if (magicCode != -1L) {
                    throw new IOException("Invalid index file: " + IndexHelper.this.m_path);
                }
                this.m_segment = segment;
                this.m_nextSegment = 1 + 4096 * headBlockIndex;
                this.m_offset = 8;
                int readerIndex = 1;
                while (readerIndex < 4096) {
                    Integer segmentNo;
                    int ip = segment.readInt();
                    int index = segment.readInt();
                    ++readerIndex;
                    if (ip == 0) break;
                    Map<Integer, Integer> map = this.m_table.get(ip);
                    if (map == null) {
                        map = new HashMap<Integer, Integer>();
                        this.m_table.put(ip, map);
                    }
                    if ((segmentNo = map.get(index)) == null) {
                        segmentNo = this.m_nextSegment++;
                        map.put(index, segmentNo);
                    }
                    this.m_offset += 8;
                }
            }
        }
    }

    private class DataHelper {
        private File m_path;
        private RandomAccessFile m_file;
        private long m_offset;
        private DataOutputStream m_out;

        private DataHelper() {
        }

        private void close() {
            try {
                if (this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            try {
                this.m_file.close();
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            this.m_file = null;
        }

        private long getDataOffset() {
            return this.m_offset;
        }

        private File getPath() {
            return this.m_path;
        }

        private void init(File dataPath) throws IOException {
            this.m_path = dataPath;
            this.m_path.getParentFile().mkdirs();
            this.m_file = new RandomAccessFile(this.m_path, "rw");
            this.m_offset = this.m_path.length();
            this.m_out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_path, true), 32768));
            if (this.m_offset == 0L) {
                this.m_out.writeInt(-1);
                this.m_offset += 4L;
            }
        }

        private byte[] read(long dataOffset) throws IOException {
            if (dataOffset < this.m_offset) {
                this.m_file.seek(dataOffset);
                int len = this.m_file.readInt();
                if (len > 0) {
                    byte[] data = new byte[len];
                    this.m_file.readFully(data);
                    return data;
                }
            }
            return null;
        }

        private void write(ByteBuf data) throws IOException {
            int len = data.readableBytes();
            this.m_out.writeInt(len);
            data.readBytes((OutputStream)this.m_out, len);
            this.m_offset += (long)(len + 4);
        }
    }
}

