/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.local;

import com.dianping.cat.Cat;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.cat.message.storage.Bucket;
import org.unidal.cat.message.storage.BucketManager;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=BucketManager.class, value="local")
public class LocalBucketManager
extends ContainerHolder
implements BucketManager,
LogEnabled {
    protected Logger m_logger;
    @Inject(value={"local"})
    private PathBuilder m_builder;
    private Map<Integer, Map<String, Bucket>> m_buckets = new LinkedHashMap<Integer, Map<String, Bucket>>();

    private boolean bucketFilesExists(String domain, String ip, int hour) {
        long timestamp = (long)(hour * 3600) * 1000L;
        Date startTime = new Date(timestamp);
        File dataPath = new File(this.m_builder.getPath(domain, startTime, ip, FileType.DATA));
        File indexPath = new File(this.m_builder.getPath(domain, startTime, ip, FileType.INDEX));
        return dataPath.exists() && indexPath.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeBuckets(int hour) {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (Map.Entry<Integer, Map<String, Bucket>> e : this.m_buckets.entrySet()) {
            int h = e.getKey();
            if (h > hour) continue;
            removed.add(h);
        }
        for (Integer h : removed) {
            Map<String, Bucket> buckets = this.m_buckets.get(h);
            if (buckets == null) continue;
            for (Bucket bucket : buckets.values()) {
                try {
                    bucket.close();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                finally {
                    super.release((Object)bucket);
                }
            }
        }
        for (Integer h : removed) {
            this.m_buckets.remove(h);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Bucket> findOrCreateMap(Map<Integer, Map<String, Bucket>> map, int hour) {
        Map<String, Bucket> m = map.get(hour);
        if (m == null) {
            Map<Integer, Map<String, Bucket>> map2 = map;
            synchronized (map2) {
                m = map.get(hour);
                if (m == null) {
                    m = new LinkedHashMap<String, Bucket>();
                    map.put(hour, m);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket getBucket(String domain, String ip, int hour, boolean createIfNotExists) throws IOException {
        Map<String, Bucket> map = this.findOrCreateMap(this.m_buckets, hour);
        Bucket bucket = map.get(domain);
        if (bucket == null) {
            boolean shouldCreate;
            boolean bl = shouldCreate = createIfNotExists || this.bucketFilesExists(domain, ip, hour);
            if (shouldCreate) {
                Map<String, Bucket> map2 = map;
                synchronized (map2) {
                    bucket = map.get(domain);
                    if (bucket == null) {
                        bucket = (Bucket)this.lookup(Bucket.class, "local");
                        bucket.initialize(domain, ip, hour, createIfNotExists);
                        map.put(domain, bucket);
                    }
                }
            }
        }
        return bucket;
    }
}

