/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.local;

import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.MessageId;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.Index;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.cat.message.storage.TokenMapping;
import org.unidal.cat.message.storage.TokenMappingManager;
import org.unidal.cat.message.storage.internals.ByteBufCache;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=Index.class, value="local", instantiationStrategy="per-lookup")
public class LocalIndex
implements Index {
    private static final int SEGMENT_SIZE = 32768;
    @Inject(value={"local"})
    private PathBuilder m_bulider;
    @Inject(value={"local"})
    private TokenMappingManager m_manager;
    @Inject
    private ByteBufCache m_bufCache;
    private TokenMapping m_mapping;
    private MessageIdCodec m_codec = new MessageIdCodec();
    private IndexHelper m_index = new IndexHelper();

    @Override
    public void close() {
        if (this.m_index.isOpen()) {
            this.m_index.close();
        }
    }

    @Override
    public MessageId find(MessageId id) throws IOException {
        long value = this.m_index.read(id);
        if (value != 0L) {
            byte[] data = this.getBytes(value);
            return this.m_codec.decode(data, id.getHour());
        }
        return null;
    }

    private byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    private long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    @Override
    public void initialize(String domain, String ip, int hour) throws IOException {
        long timestamp = (long)(hour * 3600) * 1000L;
        Date startTime = new Date(timestamp);
        File indexPath = new File(this.m_bulider.getPath(domain, startTime, ip, FileType.MAPPING));
        this.m_index.init(indexPath);
        this.m_mapping = this.m_manager.getTokenMapping(hour, ip);
    }

    @Override
    public void map(MessageId from, MessageId to) throws IOException {
        byte[] data = this.m_codec.encode(to, from.getHour());
        this.m_index.write(from, this.getLong(data));
    }

    @Override
    public void maps(Map<MessageId, MessageId> maps) throws IOException {
        for (Map.Entry<MessageId, MessageId> entry : maps.entrySet()) {
            this.map(entry.getKey(), entry.getValue());
        }
    }

    class MessageIdCodec {
        MessageIdCodec() {
        }

        private int bytesToInt(byte[] src, int offset) {
            int value = (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
            return value;
        }

        private MessageId decode(byte[] data, int currentHour) throws IOException {
            int value = this.bytesToInt(data, 0);
            int index = this.bytesToInt(data, 4);
            int s1 = value >> 17 & Short.MAX_VALUE;
            int s2 = value >> 2 & Short.MAX_VALUE;
            int s3 = value & 3;
            String domain = LocalIndex.this.m_mapping.find(s1);
            String ipAddressInHex = LocalIndex.this.m_mapping.find(s2);
            int flag = s3 >> 14 & 3;
            int hour = currentHour + (flag == 3 ? -1 : flag);
            return new MessageId(domain, ipAddressInHex, hour, index);
        }

        private byte[] encode(MessageId id, int currentHour) throws IOException {
            int domainIndex = LocalIndex.this.m_mapping.map(id.getDomain());
            int ipIndex = LocalIndex.this.m_mapping.map(id.getIpAddressInHex());
            int hour = id.getHour() - currentHour;
            int seq = id.getIndex();
            ByteBuf buf = Unpooled.buffer((int)8);
            int value = (domainIndex << 17) + (ipIndex << 2) + hour;
            buf.writeInt(value);
            buf.writeInt(seq);
            byte[] data = buf.array();
            return data;
        }
    }

    private class IndexHelper {
        private static final int BYTE_PER_MESSAGE = 8;
        private static final int BYTE_PER_ENTRY = 8;
        private static final int MESSAGE_PER_SEGMENT = 4096;
        private static final int ENTRY_PER_SEGMENT = 4096;
        private RandomAccessFile m_file;
        private File m_path;
        private FileChannel m_indexChannel;
        private Header m_header = new Header();
        private Map<String, SegmentCache> m_caches = new LinkedHashMap<String, SegmentCache>();

        private IndexHelper() {
        }

        private void close() {
            try {
                this.m_header.m_segment.close();
                for (SegmentCache cache : this.m_caches.values()) {
                    cache.close();
                }
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            try {
                this.m_indexChannel.force(false);
                this.m_indexChannel.close();
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            try {
                this.m_file.close();
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
            }
            this.m_file = null;
            this.m_caches.clear();
        }

        private Segment getSegment(String ip, long id) throws IOException {
            SegmentCache cache = this.m_caches.get(ip);
            if (cache == null) {
                cache = new SegmentCache();
                this.m_caches.put(ip, cache);
            }
            return cache.findOrCreateNextSegment(id);
        }

        private void init(File indexPath) throws IOException {
            this.m_path = indexPath;
            this.m_path.getParentFile().mkdirs();
            this.m_file = new RandomAccessFile(this.m_path, "rwd");
            this.m_indexChannel = this.m_file.getChannel();
            long size = this.m_file.length();
            int totalHeaders = (int)Math.ceil((double)size * 1.0 / 1.34217728E8);
            if (totalHeaders == 0) {
                totalHeaders = 1;
            }
            for (int i = 0; i < totalHeaders; ++i) {
                this.m_header.load(i);
            }
        }

        private boolean isOpen() {
            return this.m_file != null;
        }

        private long read(MessageId id) throws IOException {
            int index = id.getIndex();
            long position = this.m_header.getOffset(id.getIpAddressValue(), index, false);
            int segmentId = (int)(position / 32768L);
            int offset = (int)(position % 32768L);
            Segment segment = this.getSegment(id.getIpAddressInHex(), segmentId);
            if (segment != null) {
                try {
                    long blockAddress = segment.readLong(offset);
                    return blockAddress;
                }
                catch (EOFException blockAddress) {}
            } else if (position > 0L) {
                this.m_file.seek(position);
                long address = this.m_file.readLong();
                return address;
            }
            throw new RuntimeException("error when find message id:" + id.toString());
        }

        private void write(MessageId id, long value) throws IOException {
            long position = this.m_header.getOffset(id.getIpAddressValue(), id.getIndex(), true);
            long address = position / 32768L;
            int offset = (int)(position % 32768L);
            Segment segment = this.getSegment(id.getIpAddressInHex(), address);
            if (segment != null) {
                segment.writeLong(offset, value);
            } else {
                Cat.logEvent((String)"Block", (String)("Abnormal:" + id.getDomain()), (String)"0", null);
                this.m_indexChannel.position(position);
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putLong(value);
                buf.flip();
                this.m_indexChannel.write(buf);
            }
        }

        private class SegmentCache {
            private static final int CACHE_SIZE = 2;
            private long m_maxSegmentId;
            private Map<Long, Segment> m_latestSegments = new LinkedHashMap<Long, Segment>();

            private SegmentCache() {
            }

            public void close() throws IOException {
                for (Segment segment : this.m_latestSegments.values()) {
                    segment.close();
                }
                this.m_latestSegments.clear();
            }

            public Segment findOrCreateNextSegment(long segmentId) throws IOException {
                Segment segment = this.m_latestSegments.get(segmentId);
                if (segment == null) {
                    if (segmentId > this.m_maxSegmentId) {
                        if (this.m_latestSegments.size() >= 2) {
                            this.removeOldSegment();
                        }
                        segment = new Segment(IndexHelper.this.m_indexChannel, segmentId * 32768L);
                        this.m_latestSegments.put(segmentId, segment);
                        this.m_maxSegmentId = segmentId;
                    } else {
                        int duration = (int)(this.m_maxSegmentId - segmentId);
                        Cat.logEvent((String)"OldSegment", (String)String.valueOf(duration), (String)"0", (String)(String.valueOf(segmentId) + ",max:" + String.valueOf(this.m_maxSegmentId)));
                    }
                }
                return segment;
            }

            private void removeOldSegment() throws IOException {
                Map.Entry<Long, Segment> first = this.m_latestSegments.entrySet().iterator().next();
                Segment segment = this.m_latestSegments.remove(first.getKey());
                segment.close();
            }
        }

        private class Segment {
            private FileChannel m_segmentChannel;
            private long m_address;
            private ByteBuffer m_buf;

            private Segment(FileChannel channel, long address) throws IOException {
                this.m_segmentChannel = channel;
                this.m_address = address;
                this.m_buf = LocalIndex.this.m_bufCache.get();
                this.m_buf.mark();
                this.m_segmentChannel.read(this.m_buf, address);
                this.m_buf.reset();
            }

            private void close() throws IOException {
                int pos = this.m_buf.position();
                this.m_buf.position(0);
                this.m_segmentChannel.write(this.m_buf, this.m_address);
                this.m_buf.position(pos);
                LocalIndex.this.m_bufCache.put(this.m_buf);
            }

            private int readInt() throws IOException {
                return this.m_buf.getInt();
            }

            private long readLong() throws IOException {
                return this.m_buf.getLong();
            }

            private long readLong(int offset) throws IOException {
                return this.m_buf.getLong(offset);
            }

            public String toString() {
                return String.format("%s[address=%s]", this.getClass().getSimpleName(), this.m_address);
            }

            private void writeLong(int offset, long value) throws IOException {
                this.m_buf.putLong(offset, value);
            }
        }

        private class Header {
            private Map<Integer, Map<Integer, Integer>> m_table = new LinkedHashMap<Integer, Map<Integer, Integer>>();
            private int m_nextSegment;
            private Segment m_segment;
            private int m_offset;

            private Header() {
            }

            private Integer findSegment(int ip, int index, boolean createIfNotExists) throws IOException {
                Integer segmentId;
                Map<Integer, Integer> map = this.m_table.get(ip);
                if (map == null && createIfNotExists) {
                    map = new HashMap<Integer, Integer>();
                    this.m_table.put(ip, map);
                }
                Integer n = segmentId = map == null ? null : map.get(index);
                if (segmentId == null && createIfNotExists) {
                    long value = ((long)ip << 32) + (long)index;
                    segmentId = this.m_nextSegment;
                    map.put(index, segmentId);
                    this.m_segment.writeLong(this.m_offset, value);
                    this.m_offset += 8;
                    ++this.m_nextSegment;
                    if (this.m_nextSegment % 4096 == 0) {
                        this.m_segment.close();
                        this.m_segment = new Segment(IndexHelper.this.m_indexChannel, this.m_nextSegment * 32768);
                        ++this.m_nextSegment;
                        this.m_segment.writeLong(0, -1L);
                        this.m_offset = 8;
                    }
                }
                return segmentId;
            }

            private long getOffset(int ip, int seq, boolean createIfNotExists) throws IOException {
                int segmentIndex = seq / 4096;
                int segmentOffset = seq % 4096 * 8;
                Integer segmentId = this.findSegment(ip, segmentIndex, createIfNotExists);
                if (segmentId != null) {
                    long offset = segmentId * 32768 + segmentOffset;
                    return offset;
                }
                return -1L;
            }

            private void load(int headBlockIndex) throws IOException {
                Segment segment = new Segment(IndexHelper.this.m_indexChannel, headBlockIndex * 4096 * 32768);
                long magicCode = segment.readLong();
                if (magicCode == 0L) {
                    segment.writeLong(0, -1L);
                } else if (magicCode != -1L) {
                    throw new IOException("Invalid index file: " + IndexHelper.this.m_path);
                }
                this.m_segment = segment;
                this.m_nextSegment = 1 + 4096 * headBlockIndex;
                this.m_offset = 8;
                int readerIndex = 1;
                while (readerIndex < 4096) {
                    Integer segmentNo;
                    int ip = segment.readInt();
                    int index = segment.readInt();
                    ++readerIndex;
                    if (ip == 0) break;
                    Map<Integer, Integer> map = this.m_table.get(ip);
                    if (map == null) {
                        map = new HashMap<Integer, Integer>();
                        this.m_table.put(ip, map);
                    }
                    if ((segmentNo = map.get(index)) == null) {
                        segmentNo = this.m_nextSegment++;
                        map.put(index, segmentNo);
                    }
                    this.m_offset += 8;
                }
            }
        }
    }
}

