/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.message.storage.local;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.logging.Logger;
import org.unidal.cat.message.storage.FileType;
import org.unidal.cat.message.storage.Index;
import org.unidal.cat.message.storage.IndexManager;
import org.unidal.cat.message.storage.PathBuilder;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=IndexManager.class, value="local")
public class LocalIndexManager
extends ContainerHolder
implements IndexManager {
    protected Logger m_logger;
    private Map<Integer, Map<String, Index>> m_indexes = new LinkedHashMap<Integer, Map<String, Index>>();
    @Inject(value={"local"})
    private PathBuilder m_bulider;

    private boolean bucketFilesExsits(String domain, String ip, int hour) {
        long timestamp = (long)(hour * 3600) * 1000L;
        Date startTime = new Date(timestamp);
        File indexPath = new File(this.m_bulider.getPath(domain, startTime, ip, FileType.MAPPING));
        return indexPath.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int hour) {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (Map.Entry<Integer, Map<String, Index>> entry : this.m_indexes.entrySet()) {
            Integer key = entry.getKey();
            if (key > hour) continue;
            removed.add(key);
        }
        Map<Integer, Map<String, Index>> map = this.m_indexes;
        synchronized (map) {
            for (Integer i : removed) {
                Map<String, Index> value = this.m_indexes.remove(i);
                for (Index index : value.values()) {
                    index.close();
                    super.release((Object)index);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Index> findOrCreateMap(Map<Integer, Map<String, Index>> map, int hour) {
        Map<String, Index> m = map.get(hour);
        if (m == null) {
            Map<Integer, Map<String, Index>> map2 = map;
            synchronized (map2) {
                m = map.get(hour);
                if (m == null) {
                    m = new LinkedHashMap<String, Index>();
                    map.put(hour, m);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index getIndex(String domain, String ip, int hour, boolean createIfNotExists) throws IOException {
        boolean shouldCreate;
        Map<String, Index> map = this.findOrCreateMap(this.m_indexes, hour);
        Index index = map == null ? null : map.get(domain);
        boolean bl = shouldCreate = createIfNotExists && index == null || !createIfNotExists && this.bucketFilesExsits(domain, ip, hour);
        if (shouldCreate) {
            Map<String, Index> map2 = map;
            synchronized (map2) {
                index = map.get(domain);
                if (index == null) {
                    index = (Index)this.lookup(Index.class, "local");
                    index.initialize(domain, ip, hour);
                    map.put(domain, index);
                }
            }
        }
        return index;
    }
}

