/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.config.entity;

import com.dianping.cat.home.alert.config.BaseEntity;
import com.dianping.cat.home.alert.config.IVisitor;
import com.dianping.cat.home.alert.config.entity.Receiver;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertConfig
extends BaseEntity<AlertConfig> {
    private Map<String, Receiver> m_receivers = new LinkedHashMap();
    private Boolean m_enable;

    public void accept(IVisitor visitor) {
        visitor.visitAlertConfig(this);
    }

    public AlertConfig addReceiver(Receiver receiver) {
        this.m_receivers.put(receiver.getId(), receiver);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlertConfig) {
            AlertConfig _o = (AlertConfig)obj;
            if (!this.equals((Object)this.m_receivers, (Object)_o.getReceivers())) {
                return false;
            }
            return this.equals((Object)this.m_enable, (Object)_o.getEnable());
        }
        return false;
    }

    public Receiver findReceiver(String id) {
        return (Receiver)this.m_receivers.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Receiver findOrCreateReceiver(String id) {
        Receiver receiver = (Receiver)this.m_receivers.get(id);
        if (receiver == null) {
            Map map = this.m_receivers;
            synchronized (map) {
                receiver = (Receiver)this.m_receivers.get(id);
                if (receiver == null) {
                    receiver = new Receiver(id);
                    this.m_receivers.put(id, receiver);
                }
            }
        }
        return receiver;
    }

    public Boolean getEnable() {
        return this.m_enable;
    }

    public Map<String, Receiver> getReceivers() {
        return this.m_receivers;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_receivers == null ? 0 : this.m_receivers.hashCode());
        hash = hash * 31 + (this.m_enable == null ? 0 : this.m_enable.hashCode());
        return hash;
    }

    public boolean isEnable() {
        return this.m_enable != null && this.m_enable != false;
    }

    public void mergeAttributes(AlertConfig other) {
        if (other.getEnable() != null) {
            this.m_enable = other.getEnable();
        }
    }

    public Receiver removeReceiver(String id) {
        return (Receiver)this.m_receivers.remove(id);
    }

    public AlertConfig setEnable(Boolean enable) {
        this.m_enable = enable;
        return this;
    }
}

