/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.config.transform;

import com.dianping.cat.home.alert.config.entity.AlertConfig;
import com.dianping.cat.home.alert.config.entity.Receiver;
import com.dianping.cat.home.alert.config.transform.IMaker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomMaker
implements IMaker<Node> {
    public AlertConfig buildAlertConfig(Node node) {
        String enable = this.getAttribute(node, "enable");
        AlertConfig alertConfig = new AlertConfig();
        if (enable != null) {
            alertConfig.setEnable((Boolean)this.convert(Boolean.class, enable, null));
        }
        return alertConfig;
    }

    public String buildEmail(Node node) {
        return this.getText(node);
    }

    public String buildPhone(Node node) {
        return this.getText(node);
    }

    public Receiver buildReceiver(Node node) {
        String id = this.getAttribute(node, "id");
        String enable = this.getAttribute(node, "enable");
        Receiver receiver = new Receiver(id);
        if (enable != null) {
            receiver.setEnable((Boolean)this.convert(Boolean.class, enable, null));
        }
        return receiver;
    }

    public String buildWeixin(Node node) {
        return this.getText(node);
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected String getAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        return attribute == null ? null : attribute.getNodeValue();
    }

    protected Node getChildTagNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected String getText(Node node) {
        if (node != null) {
            StringBuilder sb = new StringBuilder();
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                sb.append(child.getNodeValue());
            }
            if (sb.length() != 0) {
                return sb.toString();
            }
        }
        return null;
    }
}

