/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.config.transform;

import com.dianping.cat.home.alert.config.entity.AlertConfig;
import com.dianping.cat.home.alert.config.entity.Receiver;
import com.dianping.cat.home.alert.config.transform.DefaultDomMaker;
import com.dianping.cat.home.alert.config.transform.DefaultLinker;
import com.dianping.cat.home.alert.config.transform.ILinker;
import com.dianping.cat.home.alert.config.transform.IMaker;
import com.dianping.cat.home.alert.config.transform.IParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomParser
implements IParser<Node> {
    protected Node getChildTagNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Node> getChildTagNodes(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || name != null && !child.getNodeName().equals(name)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    protected Node getDocument(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected List<Node> getGrandChildTagNodes(Node parent, String name) {
        Node child = this.getChildTagNode(parent, name);
        NodeList children = child == null ? null : child.getChildNodes();
        int len = children == null ? 0 : children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node grandChild = children.item(i);
            if (grandChild.getNodeType() != 1) continue;
            nodes.add(grandChild);
        }
        return nodes;
    }

    public AlertConfig parse(Node node) {
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), node);
    }

    public AlertConfig parse(String xml) throws SAXException, IOException {
        Node doc = this.getDocument(xml);
        Node rootNode = this.getChildTagNode(doc, "alert-config");
        if (rootNode == null) {
            throw new RuntimeException(String.format("alert-config element(%s) is expected!", "alert-config"));
        }
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), rootNode);
    }

    public AlertConfig parse(IMaker<Node> maker, ILinker linker, Node node) {
        AlertConfig alertConfig = maker.buildAlertConfig((Object)node);
        if (node != null) {
            AlertConfig parent = alertConfig;
            for (Node child : this.getChildTagNodes(node, "receiver")) {
                Receiver receiver = maker.buildReceiver((Object)child);
                if (!linker.onReceiver(parent, receiver)) continue;
                this.parseForReceiver(maker, linker, receiver, child);
            }
        }
        return alertConfig;
    }

    public void parseForReceiver(IMaker<Node> maker, ILinker linker, Receiver parent, Node node) {
        for (Node child : this.getChildTagNodes(node, "email")) {
            String email = maker.buildEmail((Object)child);
            parent.addEmail(email);
        }
        for (Node child : this.getChildTagNodes(node, "phone")) {
            String phone = maker.buildPhone((Object)child);
            parent.addPhone(phone);
        }
        for (Node child : this.getChildTagNodes(node, "weixin")) {
            String weixin = maker.buildWeixin((Object)child);
            parent.addWeixin(weixin);
        }
    }
}

