/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.policy.entity;

import com.dianping.cat.home.alert.policy.BaseEntity;
import com.dianping.cat.home.alert.policy.IVisitor;
import com.dianping.cat.home.alert.policy.entity.Level;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends BaseEntity<Group> {
    private String m_id;
    private Map<String, Level> m_levels = new LinkedHashMap();

    public Group() {
    }

    public Group(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitGroup(this);
    }

    public Group addLevel(Level level) {
        this.m_levels.put(level.getId(), level);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group _o = (Group)obj;
            return this.equals((Object)this.m_id, (Object)_o.getId());
        }
        return false;
    }

    public Level findLevel(String id) {
        return (Level)this.m_levels.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level findOrCreateLevel(String id) {
        Level level = (Level)this.m_levels.get(id);
        if (level == null) {
            Map map = this.m_levels;
            synchronized (map) {
                level = (Level)this.m_levels.get(id);
                if (level == null) {
                    level = new Level(id);
                    this.m_levels.put(id, level);
                }
            }
        }
        return level;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Level> getLevels() {
        return this.m_levels;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Group other) {
        this.assertAttributeEquals((Object)other, "group", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Level removeLevel(String id) {
        return (Level)this.m_levels.remove(id);
    }

    public Group setId(String id) {
        this.m_id = id;
        return this;
    }
}

