/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.policy.transform;

import com.dianping.cat.home.alert.policy.entity.AlertPolicy;
import com.dianping.cat.home.alert.policy.entity.Group;
import com.dianping.cat.home.alert.policy.entity.Level;
import com.dianping.cat.home.alert.policy.entity.Type;
import com.dianping.cat.home.alert.policy.transform.DefaultDomMaker;
import com.dianping.cat.home.alert.policy.transform.DefaultLinker;
import com.dianping.cat.home.alert.policy.transform.ILinker;
import com.dianping.cat.home.alert.policy.transform.IMaker;
import com.dianping.cat.home.alert.policy.transform.IParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomParser
implements IParser<Node> {
    protected Node getChildTagNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Node> getChildTagNodes(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || name != null && !child.getNodeName().equals(name)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    protected Node getDocument(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected List<Node> getGrandChildTagNodes(Node parent, String name) {
        Node child = this.getChildTagNode(parent, name);
        NodeList children = child == null ? null : child.getChildNodes();
        int len = children == null ? 0 : children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node grandChild = children.item(i);
            if (grandChild.getNodeType() != 1) continue;
            nodes.add(grandChild);
        }
        return nodes;
    }

    public AlertPolicy parse(Node node) {
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), node);
    }

    public AlertPolicy parse(String xml) throws SAXException, IOException {
        Node doc = this.getDocument(xml);
        Node rootNode = this.getChildTagNode(doc, "alert-policy");
        if (rootNode == null) {
            throw new RuntimeException(String.format("alert-policy element(%s) is expected!", "alert-policy"));
        }
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), rootNode);
    }

    public AlertPolicy parse(IMaker<Node> maker, ILinker linker, Node node) {
        AlertPolicy alertPolicy = maker.buildAlertPolicy((Object)node);
        if (node != null) {
            AlertPolicy parent = alertPolicy;
            for (Node child : this.getChildTagNodes(node, "type")) {
                Type type = maker.buildType((Object)child);
                if (!linker.onType(parent, type)) continue;
                this.parseForType(maker, linker, type, child);
            }
        }
        return alertPolicy;
    }

    public void parseForGroup(IMaker<Node> maker, ILinker linker, Group parent, Node node) {
        for (Node child : this.getChildTagNodes(node, "level")) {
            Level level = maker.buildLevel((Object)child);
            if (!linker.onLevel(parent, level)) continue;
            this.parseForLevel(maker, linker, level, child);
        }
    }

    public void parseForLevel(IMaker<Node> maker, ILinker linker, Level parent, Node node) {
    }

    public void parseForType(IMaker<Node> maker, ILinker linker, Type parent, Node node) {
        for (Node child : this.getChildTagNodes(node, "group")) {
            Group group = maker.buildGroup((Object)child);
            if (!linker.onGroup(parent, group)) continue;
            this.parseForGroup(maker, linker, group, child);
        }
    }
}

